/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.HealthCheckUserSettingsService;
import com.atlassian.support.healthcheck.api.model.HealthCheckUserSettings;
import com.atlassian.support.healthcheck.util.SupportHealthCheckUtils;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@ExperimentalApi
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@Path(value="/user-setting/{username}")
public class HealthCheckUserSettingsResource {
    private final HealthCheckUserSettingsService userSettingsService;
    private final UserManager userManager;

    public HealthCheckUserSettingsResource(HealthCheckUserSettingsService userSettingsService, UserManager userManager) {
        this.userSettingsService = userSettingsService;
        this.userManager = userManager;
    }

    @GET
    public HealthCheckUserSettings getUserSettings(@PathParam(value="username") String username) {
        UserKey userKey = this.getUserKey(username);
        return this.getUserSettings(userKey);
    }

    @GET
    @Path(value="/notification-severity")
    public SupportHealthStatus.Severity getSeverityThresholdForNotifications(@PathParam(value="username") String username) {
        return this.getUserSettings(username).getSeverityThresholdForNotifications();
    }

    @PUT
    @Path(value="/notification-severity")
    public SupportHealthStatus.Severity setSeverityThresholdForNotifications(@PathParam(value="username") String username, SupportHealthStatus.Severity severity) {
        UserKey userKey = this.getUserKey(username);
        HealthCheckUserSettings oldSettings = this.getUserSettings(userKey);
        HealthCheckUserSettings settings = HealthCheckUserSettings.builder(oldSettings).severityThreshold(severity).build();
        this.userSettingsService.setUserSettings(userKey, settings);
        return this.getUserSettings(userKey).getSeverityThresholdForNotifications();
    }

    private HealthCheckUserSettings getUserSettings(UserKey userKey) {
        return this.userSettingsService.getUserSettings(userKey);
    }

    private UserKey getUserKey(String username) {
        return SupportHealthCheckUtils.getUserKey(this.userManager, username);
    }
}

