/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.persistence.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.persistence.ao.SupportHealthcheckSchema;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatusPersistenceServiceImpl
implements HealthStatusPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(HealthStatusPersistenceServiceImpl.class);
    private static final Integer DEFAULT_NUMBER_OF_DAYS = 30;
    private final ActiveObjects ao;
    private final HealthStatusPropertiesPersistenceService propertiesPersistenceService;
    private Function<SupportHealthcheckSchema.HealthCheckStatusAO, HealthCheckStatus> aoToHealthCheckStatusConverter = status -> HealthCheckStatus.builder().id(status.getID()).completeKey(status.getCompleteKey()).name(status.getStatusName()).description(status.getDescription()).isHealthy(status.getIsHealthy()).failureReason(status.getFailureReason()).application(status.getApplicationName()).time(status.getFailedDate().getTime()).severity(SupportHealthStatus.Severity.valueOf(status.getSeverity())).build();

    public HealthStatusPersistenceServiceImpl(ActiveObjects ao, HealthStatusPropertiesPersistenceService propertiesPersistenceService) {
        this.ao = ao;
        this.propertiesPersistenceService = propertiesPersistenceService;
    }

    @Override
    public synchronized void storeFailedStatuses(List<HealthCheckStatus> statuses) {
        List<HealthCheckStatus> currentFailures = statuses.stream().filter(status -> !status.isHealthy()).collect(Collectors.toList());
        log.debug("Persisting {} failed health checks to the AO table", (Object)currentFailures.size());
        Date currentDate = new Date();
        List<HealthCheckStatus> oldFailures = this.getFailedStatuses(SupportHealthStatus.Severity.UNDEFINED);
        List<HealthCheckStatus> newFailures = this.difference(currentFailures, oldFailures);
        List<HealthCheckStatus> resolvedFailures = this.difference(oldFailures, currentFailures);
        for (HealthCheckStatus newFailure : newFailures) {
            this.storeNewFailure(newFailure, currentDate);
        }
        for (HealthCheckStatus resolvedFailure : resolvedFailures) {
            this.resolveOldFailure(resolvedFailure, currentDate);
        }
        this.propertiesPersistenceService.storeLastRun();
    }

    private void storeNewFailure(HealthCheckStatus status, Date currentDate) {
        try {
            String failureReason = status.getFailureReason();
            if (failureReason.length() > 450) {
                failureReason = failureReason.substring(0, 450);
            }
            SupportHealthcheckSchema.HealthCheckStatusAO statusEntity = (SupportHealthcheckSchema.HealthCheckStatusAO)this.ao.create(SupportHealthcheckSchema.HealthCheckStatusAO.class, new DBParam[]{new DBParam("STATUS_NAME", (Object)status.getName()), new DBParam("COMPLETE_KEY", (Object)status.getCompleteKey()), new DBParam("DESCRIPTION", (Object)status.getDescription()), new DBParam("IS_HEALTHY", (Object)status.isHealthy()), new DBParam("FAILURE_REASON", (Object)failureReason), new DBParam("APPLICATION_NAME", (Object)status.getApplication()), new DBParam("SEVERITY", (Object)status.getSeverity().toString()), new DBParam("FAILED_DATE", (Object)currentDate), new DBParam("IS_RESOLVED", (Object)false), new DBParam("RESOLVED_DATE", null)});
            statusEntity.save();
            log.debug("{} check has failed and has be persisted to the AO table.", (Object)statusEntity.getStatusName());
        }
        catch (ActiveObjectsException e) {
            log.error("There's a problem persisting new health status, {}, into the database", (Object)status.getName());
            log.error("Stacktrace for failure:", (Throwable)e);
        }
    }

    private List<HealthCheckStatus> difference(List<HealthCheckStatus> original, List<HealthCheckStatus> toRemove) {
        return original.stream().filter(healthStatusRepresentation -> {
            for (HealthCheckStatus existing : toRemove) {
                if (!existing.getName().equals(healthStatusRepresentation.getName()) || !existing.getSeverity().equals((Object)healthStatusRepresentation.getSeverity())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public List<HealthCheckStatus> getFailedStatuses(SupportHealthStatus.Severity severityLimit) {
        Query query = Query.select().where("IS_HEALTHY = ? AND IS_RESOLVED = ?", new Object[]{Boolean.FALSE, Boolean.FALSE}).order("SEVERITY ASC");
        List allFailedStatuses = Arrays.asList(this.ao.find(SupportHealthcheckSchema.HealthCheckStatusAO.class, query)).stream().map(this.aoToHealthCheckStatusConverter).collect(Collectors.toList());
        return allFailedStatuses.stream().filter(input -> input.getSeverity().compareTo(severityLimit) >= 0).collect(Collectors.toList());
    }

    @Override
    public List<Integer> deleteFailedStatusRecord(Integer days) {
        SupportHealthcheckSchema.HealthCheckStatusAO[] statuses;
        if (days == null) {
            days = DEFAULT_NUMBER_OF_DAYS;
        }
        Date timeLimit = DateUtils.addDays((Date)new Date(), (int)(-days.intValue()));
        ArrayList removedStatusIds = Lists.newArrayList();
        for (SupportHealthcheckSchema.HealthCheckStatusAO checkStatus : statuses = (SupportHealthcheckSchema.HealthCheckStatusAO[])this.ao.find(SupportHealthcheckSchema.HealthCheckStatusAO.class, Query.select().where("RESOLVED_DATE < ?", new Object[]{timeLimit}))) {
            removedStatusIds.add(checkStatus.getID());
            this.ao.delete(new RawEntity[]{checkStatus});
        }
        return removedStatusIds;
    }

    private void resolveOldFailure(HealthCheckStatus resolvedStatus, Date currentDate) {
        SupportHealthcheckSchema.HealthCheckStatusAO[] aosToUpdate;
        log.debug("Resolving the existing {} failed check", (Object)resolvedStatus.getName());
        Query query = Query.select().where("STATUS_NAME = ? AND SEVERITY = ? AND IS_RESOLVED = ?", new Object[]{resolvedStatus.getName(), resolvedStatus.getSeverity().toString(), Boolean.FALSE});
        for (SupportHealthcheckSchema.HealthCheckStatusAO healthCheckStatusAO : aosToUpdate = (SupportHealthcheckSchema.HealthCheckStatusAO[])this.ao.find(SupportHealthcheckSchema.HealthCheckStatusAO.class, query)) {
            healthCheckStatusAO.setIsHealthy(true);
            healthCheckStatusAO.setIsResolved(true);
            healthCheckStatusAO.setResolvedDate(currentDate);
            healthCheckStatusAO.save();
        }
    }
}

