/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.persistence.service;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.HealthCheckUserSettingsService;
import com.atlassian.support.healthcheck.api.model.HealthCheckUserSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;

public class HealthCheckUserSettingsServiceImpl
implements HealthCheckUserSettingsService {
    @VisibleForTesting
    static final String SEVERITY_FOR_NOTIFICATION_KEY = "support.healthcheck.notification.severity";
    private final UserSettingsService userSettingsService;

    public HealthCheckUserSettingsServiceImpl(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }

    @Override
    public HealthCheckUserSettings getUserSettings(UserKey userKey) {
        SupportHealthStatus.Severity severity = this.getSeverityForNotification(userKey);
        return HealthCheckUserSettings.builder().severityThreshold(severity).build();
    }

    @Override
    public void setUserSettings(UserKey userKey, HealthCheckUserSettings settings) {
        this.setSeverityForNotification(userKey, settings.getSeverityThresholdForNotifications());
    }

    private SupportHealthStatus.Severity getSeverityForNotification(UserKey userKey) {
        UserSettings settings = this.userSettingsService.getUserSettings(userKey);
        Option severityString = settings.getString(SEVERITY_FOR_NOTIFICATION_KEY);
        return severityString.isDefined() ? SupportHealthStatus.Severity.fromString((String)severityString.get()) : SupportHealthStatus.Severity.UNDEFINED;
    }

    private void setSeverityForNotification(UserKey userKey, final SupportHealthStatus.Severity severity) {
        this.userSettingsService.updateUserSettings(userKey, (Function)new Function<UserSettingsBuilder, UserSettings>(){

            public UserSettings apply(UserSettingsBuilder input) {
                return input.put(HealthCheckUserSettingsServiceImpl.SEVERITY_FOR_NOTIFICATION_KEY, severity.stringValue()).build();
            }
        });
    }
}

