/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.api.HealthCheckUserSettingsService;
import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatusReport;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServiceImpl
implements HealthCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckServiceImpl.class);
    private final HealthStatusPersistenceService statusPersistenceService;
    private final NotificationDismissPersistenceService notificationService;
    private final HealthCheckUserSettingsService userSettingsService;
    private final SupportHealthCheckManager healthCheckManager;

    public HealthCheckServiceImpl(HealthCheckUserSettingsService userSettingsService, HealthStatusPersistenceService statusPersistenceService, NotificationDismissPersistenceService notificationService, SupportHealthCheckManager healthCheckManager) {
        this.statusPersistenceService = statusPersistenceService;
        this.notificationService = notificationService;
        this.userSettingsService = userSettingsService;
        this.healthCheckManager = healthCheckManager;
    }

    @Override
    public HealthCheckStatusReport getStatusesForUserNotifications(UserKey userKey) {
        SupportHealthStatus.Severity severityThreshold = this.userSettingsService.getUserSettings(userKey).getSeverityThresholdForNotifications();
        List<HealthCheckStatus> failedStatuses = this.statusPersistenceService.getFailedStatuses(severityThreshold);
        if (failedStatuses.isEmpty()) {
            return HealthCheckStatusReport.builder().build();
        }
        List<HealthCheckStatus> statuses = failedStatuses.stream().filter(status -> {
            for (Integer id : this.notificationService.getDismissedNotificationByUser(userKey)) {
                if (status.getId() != id.intValue()) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return HealthCheckStatusReport.builder().statuses(statuses).build();
    }

    @Override
    public HealthCheckStatusReport runChecks(HealthCheckFilter filter) {
        List<HealthCheckStatus> statuses = this.healthCheckManager.performChecks(filter);
        this.statusPersistenceService.storeFailedStatuses(statuses);
        return HealthCheckStatusReport.builder().statuses(statuses).build();
    }

    @Override
    public HealthCheckStatusReport getCheckResultsFromProcess(UUID uuid) {
        List<HealthCheckStatus> statuses = this.healthCheckManager.getCheckResults(uuid);
        if (statuses != null) {
            return HealthCheckStatusReport.builder().statuses(statuses).build();
        }
        return null;
    }
}

