/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.support.healthcheck.api.FileSystemInfo;
import com.atlassian.support.healthcheck.api.RuntimeHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemInfoImpl
implements FileSystemInfo {
    private static final String UNLIMITED = "unlimited";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemInfoImpl.class);
    private final RuntimeHelper runtime;

    public FileSystemInfoImpl(RuntimeHelper runtime) {
        this.runtime = runtime;
    }

    @Override
    public FileStore getFileStore(String path) throws IOException {
        return Files.getFileStore(Paths.get(path, new String[0]).toRealPath(new LinkOption[0]));
    }

    @Override
    public Optional<FileSystemInfo.ThreadLimit> getThreadLimit() {
        return this.runtime.spawnProcessSafely("bash", "-c", "ulimit -u").map(process -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String result = reader.readLine();
                FileSystemInfo.ThreadLimit threadLimit = FileSystemInfo.ThreadLimit.threadLimit(UNLIMITED.equals(result) ? 0 : Integer.parseInt(result));
                return threadLimit;
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.warn("Failed to determine the configured process limit", (Throwable)e);
                return null;
            }
        });
    }
}

