/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.DefaultSupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthCheckSupplier;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckProcess;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckTask;
import com.atlassian.support.healthcheck.event.SupportHealthCheckTimeoutEvent;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.impl.Pair;
import com.atlassian.support.healthcheck.impl.SupportHealthCheckManager;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.thread.HealthCheckCallable;
import com.atlassian.support.healthcheck.thread.HealthCheckProcessCallable;
import com.atlassian.support.healthcheck.thread.HealthCheckThreadFactory;
import com.atlassian.support.healthcheck.util.SupportHealthCheckUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultSupportHealthCheckManager
implements SupportHealthCheckManager,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultSupportHealthCheckManager.class);
    private static final String STP_KEY = "com.atlassian.support.stp";
    private static final String SHC_KEY = "com.atlassian.support.healthcheck.support-healthcheck-plugin";
    private static final int CHECK_THREAD_COUNT = Integer.getInteger("atlassian.healthcheck.thread-count", 8);
    private static Map<UUID, SupportHealthCheckProcess> processes = new ConcurrentHashMap<UUID, SupportHealthCheckProcess>();
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final SupportHealthCheckSupplier healthCheckSupplier;
    private final HealthStatusPersistenceService healthStatusPersistenceService;
    private ExecutorService executorService;

    public DefaultSupportHealthCheckManager(ApplicationProperties applicationProperties, EventPublisher eventPublisher, PluginAccessor pluginAccessor, SupportHealthCheckSupplier healthCheckSupplier, HealthStatusPersistenceService healthStatusPersistenceService) {
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.healthCheckSupplier = healthCheckSupplier;
        this.healthStatusPersistenceService = healthStatusPersistenceService;
    }

    public void afterPropertiesSet() throws Exception {
        this.startThreadPool();
    }

    public void destroy() throws Exception {
        this.stopThreadPool();
    }

    void startThreadPool() {
        this.executorService = Executors.newFixedThreadPool(CHECK_THREAD_COUNT, new HealthCheckThreadFactory());
    }

    void stopThreadPool() {
        this.executorService.shutdownNow();
    }

    @Override
    public Collection<ExtendedSupportHealthCheck> getHealthChecks(HealthCheckFilter filter) {
        return this.healthCheckSupplier.getHealthChecks(filter);
    }

    @Override
    public List<HealthCheckStatus> performChecks(HealthCheckFilter filter) {
        Collection<ExtendedSupportHealthCheck> healthChecks = this.getHealthChecks(filter);
        ArrayList<Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>> futurePairs = new ArrayList<Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>>(healthChecks.size());
        for (ExtendedSupportHealthCheck check : healthChecks) {
            Future<SupportHealthStatus> future = this.executorService.submit(new HealthCheckCallable(check));
            futurePairs.add(new Pair<Future<SupportHealthStatus>, ExtendedSupportHealthCheck>(future, check));
        }
        return Lists.transform(futurePairs, pair -> this.getHealthCheckStatus((ExtendedSupportHealthCheck)pair.getRight(), (Future)pair.getLeft()));
    }

    @Override
    public UUID startCheckProcess(HealthCheckFilter filter) {
        Collection<ExtendedSupportHealthCheck> healthChecks = this.getHealthChecks(filter);
        UUID uuid = UUID.randomUUID();
        SupportHealthCheckProcess process = null;
        try {
            process = new SupportHealthCheckProcess();
            for (ExtendedSupportHealthCheck check : healthChecks) {
                process.addTask(check);
            }
            this.executorService.submit(new HealthCheckProcessCallable(process, this.healthStatusPersistenceService::storeFailedStatuses));
            UUID uUID = uuid;
            return uUID;
        }
        catch (Exception e) {
            log.error("Unable to perform health check", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUpHealthCheckProcess();
            if (process != null) {
                processes.put(uuid, process);
            }
        }
    }

    @Override
    public List<HealthCheckStatus> getCheckResults(UUID uuid) {
        SupportHealthCheckProcess process = processes.get(uuid);
        if (process != null) {
            Collection<SupportHealthCheckTask> tasks = process.getTasks();
            ArrayList<HealthCheckStatus> completed = new ArrayList<HealthCheckStatus>();
            for (SupportHealthCheckTask task : tasks) {
                SupportHealthStatus status;
                if (!task.getStatus().equals((Object)SupportHealthCheckTask.SupportHealthCheckTaskStatus.COMPLETED)) continue;
                ExtendedSupportHealthCheck check = (ExtendedSupportHealthCheck)task.getWork();
                try {
                    status = task.getHealthStatus();
                }
                catch (InterruptedException e) {
                    status = new SupportHealthStatusFactory(Application.Unknown, "").failed("Exception during check invocation: " + e.getMessage(), SupportHealthStatus.Severity.MAJOR);
                }
                completed.add(SupportHealthCheckUtils.asHealthCheckStatus(check, status));
            }
            return completed;
        }
        return null;
    }

    private void cleanUpHealthCheckProcess() {
        if (!processes.isEmpty()) {
            DateTime currentTime = DateTime.now();
            for (Map.Entry<UUID, SupportHealthCheckProcess> entry : processes.entrySet()) {
                SupportHealthCheckProcess process = entry.getValue();
                DateTime processDateTime = process.getProcessDateTime();
                if (processDateTime != null && Days.daysBetween(process.getProcessDateTime(), currentTime).getDays() < 1) continue;
                processes.remove(entry.getKey());
            }
        }
    }

    private HealthCheckStatus getHealthCheckStatus(ExtendedSupportHealthCheck healthCheck, Future<SupportHealthStatus> future) {
        SupportHealthStatus status;
        block4: {
            try {
                status = future.get(healthCheck.getTimeOut(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                status = this.buildFailureStatus("InterruptedException: " + e.getMessage());
                log.info(e.getMessage(), (Throwable)e);
            }
            catch (ExecutionException e) {
                status = this.buildFailureStatus("ExecutionException: " + e.getMessage());
                log.info(e.getMessage(), (Throwable)e);
            }
            catch (CancellationException | TimeoutException e) {
                status = this.buildFailureStatus("TimeoutException after " + healthCheck.getTimeOut() + "ms");
                if (future.isCancelled()) break block4;
                future.cancel(true);
                log.info(e.getMessage(), (Throwable)e);
                this.triggerHealthcheckTimeoutEvent(healthCheck);
            }
        }
        return SupportHealthCheckUtils.asHealthCheckStatus(healthCheck, status);
    }

    private DefaultSupportHealthStatus buildFailureStatus(String failureReason) {
        return new DefaultSupportHealthStatus(false, failureReason, System.currentTimeMillis(), Application.Unknown, SupportHealthStatus.Severity.UNDEFINED, "");
    }

    private void triggerHealthcheckTimeoutEvent(ExtendedSupportHealthCheck healthCheck) {
        String productName = this.applicationProperties.getDisplayName().toLowerCase();
        String productVersion = this.applicationProperties.getVersion();
        String ihKey = String.format("com.atlassian.%s.plugins.%s-healthcheck-plugin", productName, productName);
        String ihVersion = this.pluginAccessor.getPlugin(ihKey).getPluginInformation().getVersion();
        String stpVersion = this.pluginAccessor.getPlugin(STP_KEY).getPluginInformation().getVersion();
        String shcVersion = this.pluginAccessor.getPlugin(SHC_KEY).getPluginInformation().getVersion();
        SupportHealthCheckTimeoutEvent event = new SupportHealthCheckTimeoutEvent(this.applicationProperties.getDisplayName(), healthCheck.getName(), healthCheck.getTimeOut(), productVersion, ihVersion, shcVersion, stpVersion);
        this.eventPublisher.publish((Object)event);
    }
}

