/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.concurrent;

import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckTask;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.time.DateTime;

public class SupportHealthCheckProcess {
    private final Collection<SupportHealthCheckTask> tasks = new CopyOnWriteArrayList<SupportHealthCheckTask>();
    private DateTime processDateTime;

    public <T> void addTask(T work) {
        this.tasks.add(new SupportHealthCheckTask<T>(work));
        this.processDateTime = DateTime.now();
    }

    public Collection<SupportHealthCheckTask> getTasks() {
        return Collections.unmodifiableCollection(this.tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SupportHealthStatus run(T work) {
        T t = work;
        synchronized (t) {
            for (SupportHealthCheckTask t2 : this.tasks) {
                ExtendedSupportHealthCheck check = (ExtendedSupportHealthCheck)t2.getWork();
                if (!check.equals(work)) continue;
                try {
                    return t2.run(check);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void complete(T work, SupportHealthStatus status) {
        T t = work;
        synchronized (t) {
            for (SupportHealthCheckTask t2 : this.tasks) {
                ExtendedSupportHealthCheck check = (ExtendedSupportHealthCheck)t2.getWork();
                if (!check.equals(work)) continue;
                t2.complete(status);
            }
        }
    }

    public DateTime getProcessDateTime() {
        return this.processDateTime;
    }
}

