/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.checks;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthCheck;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.FileSystemInfo;
import com.atlassian.support.healthcheck.api.IndexInfoService;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkMountHealthCheck
implements SupportHealthCheck {
    private static final String HELP_PATH = "healthcheck.network.mount.url";
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkMountHealthCheck.class);
    private final FileSystemInfo fileSystemInfo;
    private final I18nResolver i18nResolver;
    private final SupportHealthStatusFactory healthStatusFactory;
    private final IndexInfoService indexInfo;

    public NetworkMountHealthCheck(I18nResolver i18nResolver, HelpPathResolver helpPathResolver, FileSystemInfo fileSystemInfo, ApplicationProperties properties, IndexInfoService indexInfo) {
        this.i18nResolver = i18nResolver;
        this.fileSystemInfo = fileSystemInfo;
        this.indexInfo = indexInfo;
        this.healthStatusFactory = new SupportHealthStatusFactory(Application.byAppDisplayName(properties.getDisplayName()), helpPathResolver.getHelpPath(HELP_PATH).getUrl());
    }

    @Override
    public SupportHealthStatus check() {
        String indexMount = this.getIndexFileStoreMount();
        if (indexMount.toLowerCase().equals("nfs")) {
            return this.healthStatusFactory.failed(this.i18nResolver.getText("healthcheck.network.mount.warn", new Serializable[]{this.indexInfo.getIndexRootPath(), indexMount}), SupportHealthStatus.Severity.WARNING);
        }
        return this.healthStatusFactory.healthy(this.i18nResolver.getText("healthcheck.network.mount.ok", new Serializable[]{this.indexInfo.getIndexRootPath(), indexMount}));
    }

    private String getIndexFileStoreMount() {
        try {
            return this.fileSystemInfo.getFileStore(this.indexInfo.getIndexRootPath()).type();
        }
        catch (IOException e) {
            LOGGER.info("Cannot execute health check as index path lookup is failing due to: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

