/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.api.model;

import com.atlassian.support.healthcheck.SupportHealthStatus;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class HealthCheckUserSettings {
    @JsonProperty
    private final SupportHealthStatus.Severity severityThresholdForNotifications;

    @JsonCreator
    private HealthCheckUserSettings() {
        this(HealthCheckUserSettings.builder());
    }

    private HealthCheckUserSettings(Builder builder) {
        this.severityThresholdForNotifications = builder.severityThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HealthCheckUserSettings original) {
        return HealthCheckUserSettings.builder().severityThreshold(original.severityThresholdForNotifications);
    }

    public SupportHealthStatus.Severity getSeverityThresholdForNotifications() {
        return this.severityThresholdForNotifications;
    }

    public static class Builder {
        private SupportHealthStatus.Severity severityThreshold = SupportHealthStatus.Severity.UNDEFINED;

        private Builder() {
        }

        public Builder severityThreshold(SupportHealthStatus.Severity severityThreshold) {
            this.severityThreshold = severityThreshold;
            return this;
        }

        public HealthCheckUserSettings build() {
            return new HealthCheckUserSettings(this);
        }
    }
}

