/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck;

import com.atlassian.extras.api.Product;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.StreamSupport;

public enum Application {
    Confluence(Product.CONFLUENCE),
    JIRA(Product.JIRA),
    FECRU(Product.FISHEYE, Product.CRUCIBLE),
    Crowd(Product.CROWD),
    Bamboo(Product.BAMBOO),
    Stash(Product.STASH),
    Plugin(Product.ALL_PLUGINS),
    Unknown(new Product[0]);

    private final Set<Product> products;

    private Application(Product ... products) {
        this.products = Collections.unmodifiableSet(Sets.newHashSet((Object[])products));
    }

    public static Application byProduct(Product product) {
        return Arrays.stream(Application.values()).filter(a -> a.products.contains(product)).findAny().orElse(Unknown);
    }

    public static Application byAppDisplayName(String displayName) {
        return Application.byProduct(StreamSupport.stream(Product.ATLASSIAN_PRODUCTS.spliterator(), false).filter(p -> p.getName().equals(displayName)).findAny().orElse(null));
    }
}

