/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.util;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.common.Option;
import com.opensymphony.util.TextUtils;
import java.awt.Dimension;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class RenderingUtilities {
    private static final String[] RESOURCES = new String[]{"com.atlassian.streams.streams-jira-plugin:streamsWebResources"};
    private static final int MAX_THUMBNAIL_HEIGHT = 100;

    private RenderingUtilities() {
    }

    public static Dimension scaleToThumbnailSize(int width, int height) {
        if (height < 1) {
            throw new IllegalArgumentException("Height cannot be less than 1.");
        }
        if (width < 1) {
            throw new IllegalArgumentException("Width cannot be less than 1.");
        }
        double scaleFactor = height > 100 ? 100.0 / (double)height : 1.0;
        return new Dimension((int)((double)width * scaleFactor), (int)((double)height * scaleFactor));
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            return null;
        }
        return TextUtils.htmlEncode((String)s);
    }

    public static String span(String classAttribute, String html) {
        if (classAttribute == null) {
            throw new IllegalArgumentException("Class attribute is null");
        }
        if (html == null) {
            throw new IllegalArgumentException("HTML is null");
        }
        return "<span class='" + classAttribute + "'>" + html + "</span>";
    }

    public static String link(String uri, String label) {
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        return StringUtils.isNotBlank((String)uri) ? "<a href=\"" + uri + "\">" + RenderingUtilities.htmlEncode(label) + "</a>" : RenderingUtilities.htmlEncode(label);
    }

    public static Html link(Option<URI> uri, Html label) {
        if (label == null) {
            throw new IllegalArgumentException("Label is null");
        }
        return uri.isDefined() ? new Html("<a href=\"" + ((URI)uri.get()).toASCIIString() + "\">" + label + "</a>") : label;
    }

    public static void includeActivityStreamResources(WebResourceManager webResourceManager) {
        for (String resource : RESOURCES) {
            webResourceManager.requireResource(resource);
        }
    }
}

