/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;

class UserHistory {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ChangeHistoryManager changeHistoryManager;
    private final UserKeyService userKeyService;
    private final Function<String, String> keyToUsername = new Function<String, String>(){

        public String apply(String username) {
            return UserHistory.this.userKeyService.getKeyForUsername(username);
        }
    };
    private final Function<String, Project> toProject = new Function<String, Project>(){

        public Project apply(String key) {
            return UserHistory.this.projectManager.getProjectObjByKey(key);
        }
    };
    private final Predicate<Project> hasPermission = new Predicate<Project>(){

        public boolean apply(Project project) {
            return UserHistory.this.permissionManager.hasPermission(10, project, UserHistory.this.authenticationContext.getLoggedInUser());
        }
    };

    public UserHistory(ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, ChangeHistoryManager changeHistoryManager, UserKeyService userKeyService) {
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager, (Object)"projectManager");
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
        this.changeHistoryManager = (ChangeHistoryManager)Preconditions.checkNotNull((Object)changeHistoryManager, (Object)"changeHistoryManager");
        this.userKeyService = userKeyService;
    }

    public Set<Issue> find(ActivityRequest request) {
        ImmutableSet projects = ImmutableSet.copyOf(this.getProjects(request));
        if (projects.isEmpty()) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Collection)this.changeHistoryManager.findUserHistory(this.authenticationContext.getLoggedInUser(), this.getUsers(request), (Collection)projects, request.getMaxResults()));
    }

    private Collection<String> getUsers(ActivityRequest request) {
        Collection filters = request.getStandardFilters().get((Object)StandardStreamsFilterOption.USER.getKey());
        if (filters.isEmpty()) {
            return null;
        }
        Set result = Filters.getIsValues((Iterable)filters);
        if (result.isEmpty()) {
            return null;
        }
        ImmutableSet keysFromNames = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)result, this.keyToUsername), (Predicate)Predicates.notNull()));
        return keysFromNames.isEmpty() ? null : keysFromNames;
    }

    private Iterable<Project> getProjects(ActivityRequest request) {
        Set projectKeys = Filters.getIsValues((Iterable)request.getStandardFilters().get((Object)"key"));
        if (!Iterables.isEmpty((Iterable)projectKeys)) {
            return Iterables.filter((Iterable)Iterables.transform((Iterable)projectKeys, this.toProject), (Predicate)Predicates.and((Predicate)Predicates.notNull(), this.hasPermission));
        }
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getLoggedInUser());
    }
}

