/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.search;

import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.query.clause.Clause;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsFilterType;
import com.atlassian.streams.api.common.Fold;
import com.atlassian.streams.api.common.Function2;
import com.atlassian.streams.api.common.Functions;
import com.atlassian.streams.api.common.Iterables;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.common.Pairs;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;

public final class Jql {
    public static final int MIN_PAGING_RESULTS = 10;

    static Clause filterByProject(ActivityRequest request) {
        return Jql.filterBy(request.getStandardFilters().get((Object)"key"), Jql.toProjectClause());
    }

    static Clause filterByDate(ActivityRequest request) {
        return Jql.filterBy(request.getStandardFilters().get((Object)StandardStreamsFilterOption.UPDATE_DATE.getKey()), Jql.toCreatedOrUpdatedClause());
    }

    static Clause filterByIssueType(ActivityRequest request) {
        return Jql.filterBy(request.getProviderFilters().get((Object)"issue_type"), Jql.toIssueTypeClause());
    }

    static Clause filterByProjectCategory(ActivityRequest request) {
        return Jql.filterBy(request.getProviderFilters().get((Object)"project_category"), Jql.toProjectCategoryClause());
    }

    static Clause filterByIssueKey(ActivityRequest request) {
        return Jql.filterBy(request.getStandardFilters().get((Object)StandardStreamsFilterOption.ISSUE_KEY.getKey()), Jql.toIssueKeyClause());
    }

    static Clause filterByUser(ActivityRequest request) {
        return Jql.filterBy(request.getStandardFilters().get((Object)StandardStreamsFilterOption.USER.getKey()), Jql.toReporterClause());
    }

    private static Clause filterBy(Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> filters, Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause> toClause) {
        return Jql.and(com.google.common.collect.Iterables.transform(filters, toClause));
    }

    private static ToProjectClause toProjectClause() {
        return ToProjectClause.INSTANCE;
    }

    private static ToIssueKeyClause toIssueKeyClause() {
        return ToIssueKeyClause.INSTANCE;
    }

    private static ToReporterClause toReporterClause() {
        return ToReporterClause.INSTANCE;
    }

    private static ToIssueTypeClause toIssueTypeClause() {
        return ToIssueTypeClause.INSTANCE;
    }

    private static ToProjectCategoryClause toProjectCategoryClause() {
        return ToProjectCategoryClause.INSTANCE;
    }

    private static ToCreatedOrUpdatedClauses toCreatedOrUpdatedClause() {
        return ToCreatedOrUpdatedClauses.INSTANCE;
    }

    private static Clause and(Iterable<Clause> clauses) {
        if (com.google.common.collect.Iterables.isEmpty(clauses)) {
            return JqlQueryBuilder.newClauseBuilder().buildClause();
        }
        return ((JqlClauseBuilder)Fold.foldl((Iterable)Iterables.drop((int)1, clauses), (Object)JqlQueryBuilder.newClauseBuilder((Clause)((Clause)com.google.common.collect.Iterables.get(clauses, (int)0))), (Function2)AndClauses.INSTANCE)).buildClause();
    }

    private static Clause or(Iterable<Clause> clauses) {
        if (com.google.common.collect.Iterables.isEmpty(clauses)) {
            return JqlQueryBuilder.newClauseBuilder().buildClause();
        }
        return ((JqlClauseBuilder)Fold.foldl((Iterable)Iterables.drop((int)1, clauses), (Object)JqlQueryBuilder.newClauseBuilder((Clause)((Clause)com.google.common.collect.Iterables.get(clauses, (int)0))), (Function2)OrClauses.INSTANCE)).buildClause();
    }

    private static Iterable<Clause> before(Supplier<ConditionBuilder> supplier, Iterable<Date> dates) {
        return com.google.common.collect.Iterables.transform(dates, Jql.toBeforeClause(supplier));
    }

    private static Function<Date, Clause> toBeforeClause(Supplier<ConditionBuilder> supplier) {
        return new ToBeforeClause(supplier);
    }

    private static Iterable<Clause> after(Supplier<ConditionBuilder> supplier, Iterable<Date> dates) {
        return com.google.common.collect.Iterables.transform(dates, Jql.toAfterClause(supplier));
    }

    private static Function<Date, Clause> toAfterClause(Supplier<ConditionBuilder> supplier) {
        return new ToAfterClause(supplier);
    }

    private static Iterable<Clause> between(Supplier<ConditionBuilder> supplier, Iterable<Pair<Date, Date>> dates) {
        return com.google.common.collect.Iterables.transform(dates, Jql.toBetweenClause(supplier));
    }

    private static Function<Pair<Date, Date>, Clause> toBetweenClause(Supplier<ConditionBuilder> supplier) {
        return new ToBetweenClause(supplier);
    }

    private static Supplier<ConditionBuilder> created() {
        return CreatedConditionBuilderSupplier.INSTANCE;
    }

    private static Supplier<ConditionBuilder> updated() {
        return UpdatedConditionBuilderSupplier.INSTANCE;
    }

    private static enum UpdatedConditionBuilderSupplier implements Supplier<ConditionBuilder>
    {
        INSTANCE;


        public ConditionBuilder get() {
            return JqlQueryBuilder.newClauseBuilder().updated();
        }
    }

    private static enum CreatedConditionBuilderSupplier implements Supplier<ConditionBuilder>
    {
        INSTANCE;


        public ConditionBuilder get() {
            return JqlQueryBuilder.newClauseBuilder().created();
        }
    }

    private static final class ToBetweenClause
    implements Function<Pair<Date, Date>, Clause> {
        private final Supplier<ConditionBuilder> supplier;

        public ToBetweenClause(Supplier<ConditionBuilder> supplier) {
            this.supplier = supplier;
        }

        public Clause apply(Pair<Date, Date> ds) {
            return ((ConditionBuilder)this.supplier.get()).range(Long.valueOf(((Date)ds.first()).getTime()), Long.valueOf(((Date)ds.second()).getTime())).buildClause();
        }
    }

    private static final class ToAfterClause
    implements Function<Date, Clause> {
        private final Supplier<ConditionBuilder> supplier;

        public ToAfterClause(Supplier<ConditionBuilder> supplier) {
            this.supplier = supplier;
        }

        public Clause apply(Date d) {
            return ((ConditionBuilder)this.supplier.get()).gtEq(Long.valueOf(d.getTime())).buildClause();
        }
    }

    private static final class ToBeforeClause
    implements Function<Date, Clause> {
        private final Supplier<ConditionBuilder> supplier;

        public ToBeforeClause(Supplier<ConditionBuilder> supplier) {
            this.supplier = supplier;
        }

        public Clause apply(Date d) {
            return ((ConditionBuilder)this.supplier.get()).ltEq(Long.valueOf(d.getTime())).buildClause();
        }
    }

    private static enum OrClauses implements Function2<Clause, JqlClauseBuilder, JqlClauseBuilder>
    {
        INSTANCE;


        public JqlClauseBuilder apply(Clause clause, JqlClauseBuilder builder) {
            return builder.or().addClause(clause);
        }
    }

    private static enum AndClauses implements Function2<Clause, JqlClauseBuilder, JqlClauseBuilder>
    {
        INSTANCE;


        public JqlClauseBuilder apply(Clause clause, JqlClauseBuilder builder) {
            return builder.and().addClause(clause);
        }
    }

    private static enum ToCreatedOrUpdatedClauses implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> dateFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().sub();
            ImmutableList dates = ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.transform((Iterable)((Iterable)dateFilter.second()), (Function)Filters.toDate()));
            switch ((StreamsFilterType.Operator)dateFilter.first()) {
                case BEFORE: {
                    builder.addClause(Jql.or(Jql.before((Supplier<ConditionBuilder>)Jql.created(), (Iterable)dates))).or().addClause(Jql.or(Jql.before((Supplier<ConditionBuilder>)Jql.updated(), (Iterable)dates)));
                    break;
                }
                case AFTER: {
                    builder.addClause(Jql.or(Jql.after((Supplier<ConditionBuilder>)Jql.created(), (Iterable)dates))).or().addClause(Jql.or(Jql.after((Supplier<ConditionBuilder>)Jql.updated(), (Iterable)dates)));
                    break;
                }
                case BETWEEN: {
                    Iterable ranges = Pairs.mkPairs((Iterable)dates);
                    builder.addClause(Jql.or(Jql.between((Supplier<ConditionBuilder>)Jql.created(), ranges))).or().addClause(Jql.or(Jql.between((Supplier<ConditionBuilder>)Jql.updated(), ranges)));
                }
            }
            return builder.endsub().buildClause();
        }
    }

    private static enum ToProjectCategoryClause implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> issueTypeFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            Long[] categoryIds = (Long[])com.google.common.collect.Iterables.toArray((Iterable)com.google.common.collect.Iterables.transform((Iterable)((Iterable)issueTypeFilter.second()), (Function)Functions.parseLong()), Long.class);
            switch ((StreamsFilterType.Operator)issueTypeFilter.first()) {
                case IS: {
                    builder.category().in(categoryIds);
                    break;
                }
                case NOT: {
                    builder.category().isEmpty().or().category().notIn(categoryIds);
                }
            }
            return builder.buildClause();
        }
    }

    private static enum ToIssueTypeClause implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> issueTypeFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            switch ((StreamsFilterType.Operator)issueTypeFilter.first()) {
                case IS: {
                    builder.issueType().inStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)issueTypeFilter.second())));
                    break;
                }
                case NOT: {
                    builder.issueType().notInStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)issueTypeFilter.second())));
                }
            }
            return builder.buildClause();
        }
    }

    private static enum ToReporterClause implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> userFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            switch ((StreamsFilterType.Operator)userFilter.first()) {
                case IS: {
                    builder.reporter().inStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)userFilter.second())));
                    break;
                }
                case NOT: {
                    builder.reporter().notInStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)userFilter.second())));
                }
            }
            return builder.buildClause();
        }
    }

    private static enum ToIssueKeyClause implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> projectFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            switch ((StreamsFilterType.Operator)projectFilter.first()) {
                case IS: {
                    builder.issue().inStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)projectFilter.second())));
                    break;
                }
                case NOT: {
                    builder.issue().notInStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)projectFilter.second())));
                }
            }
            return builder.buildClause();
        }
    }

    private static enum ToProjectClause implements Function<Pair<StreamsFilterType.Operator, Iterable<String>>, Clause>
    {
        INSTANCE;


        public Clause apply(Pair<StreamsFilterType.Operator, Iterable<String>> projectFilter) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            switch ((StreamsFilterType.Operator)projectFilter.first()) {
                case IS: {
                    builder.project().inStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)projectFilter.second())));
                    break;
                }
                case NOT: {
                    builder.project().notInStrings((Collection)ImmutableList.copyOf((Iterable)((Iterable)projectFilter.second())));
                }
            }
            return builder.buildClause();
        }
    }
}

