/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.search;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.jira.search.IssueSearch;
import com.atlassian.streams.jira.search.UserHistory;
import com.atlassian.streams.spi.Filters;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Set;

public class IssueFinder {
    private final UserHistory userHistory;
    private final IssueSearch issueSearch;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final Predicate<Issue> hasBrowsePermission = new Predicate<Issue>(){

        public boolean apply(Issue issue) {
            return issue != null && IssueFinder.this.permissionManager.hasPermission(10, issue, IssueFinder.this.authenticationContext.getLoggedInUser());
        }
    };

    public IssueFinder(UserHistory userHistory, IssueSearch issueSearch, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.userHistory = (UserHistory)Preconditions.checkNotNull((Object)userHistory, (Object)"userHistory");
        this.issueSearch = (IssueSearch)Preconditions.checkNotNull((Object)issueSearch, (Object)"issueSearch");
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
    }

    public Set<Issue> find(ActivityRequest request) throws StreamsException {
        Sets.SetView issues = Sets.union(this.issueSearch.search(request), this.userHistory.find(request));
        return Sets.filter((Set)issues, (Predicate)Predicates.and((Predicate[])new Predicate[]{this.issueKey((Predicate<String>)Filters.inIssueKeys((ActivityRequest)request, (Function)Filters.caseInsensitive((Function)Filters.isIn()), (Function)Filters.caseInsensitive((Function)Filters.notIn()))), this.hasBrowsePermission, this.hasIssueType(request), this.hasProjectCategory(request), this.hasProjectKey(request)}));
    }

    private Predicate<Issue> issueKey(Predicate<String> issueKeyPredicate) {
        return new IssueKeyPredicateWrapper(issueKeyPredicate);
    }

    private Predicate<Issue> hasIssueType(ActivityRequest request) {
        return new HasIssueType(request);
    }

    private Predicate<Issue> hasProjectCategory(ActivityRequest request) {
        return new HasProjectCategory(request);
    }

    private Predicate<Issue> hasProjectKey(ActivityRequest request) {
        return new HasProjectKey(request);
    }

    private class HasProjectKey
    implements Predicate<Issue> {
        private final ActivityRequest request;

        public HasProjectKey(ActivityRequest request) {
            this.request = request;
        }

        public boolean apply(Issue issue) {
            return issue != null && Filters.isAndNot((Iterable)this.request.getStandardFilters().get((Object)"key")).apply((Object)issue.getProjectObject().getKey());
        }
    }

    private static class HasProjectCategory
    implements Predicate<Issue> {
        private final ActivityRequest request;

        public HasProjectCategory(ActivityRequest request) {
            this.request = request;
        }

        public boolean apply(Issue issue) {
            if (issue == null) {
                return false;
            }
            ProjectCategory projectCategoryObject = issue.getProjectObject().getProjectCategoryObject();
            String categoryId = projectCategoryObject != null ? String.valueOf(projectCategoryObject.getId()) : null;
            return Filters.isAndNot((Iterable)this.request.getProviderFilters().get((Object)"project_category")).apply((Object)categoryId);
        }
    }

    private class HasIssueType
    implements Predicate<Issue> {
        private final ActivityRequest request;

        public HasIssueType(ActivityRequest request) {
            this.request = request;
        }

        public boolean apply(Issue issue) {
            return issue != null && Filters.isAndNot((Iterable)this.request.getProviderFilters().get((Object)"issue_type")).apply((Object)issue.getIssueTypeObject().getId());
        }
    }

    private static final class IssueKeyPredicateWrapper
    implements Predicate<Issue> {
        private final Predicate<String> issueKeyPredicate;

        public IssueKeyPredicateWrapper(Predicate<String> issueKeyPredicate) {
            this.issueKeyPredicate = issueKeyPredicate;
        }

        public boolean apply(Issue issue) {
            return this.issueKeyPredicate.apply((Object)issue.getKey());
        }
    }
}

