/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.rest.resources;

import com.atlassian.streams.jira.JiraInlineActionHandler;
import com.google.common.base.Preconditions;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/actions")
public class JiraInlineActionResource {
    private final JiraInlineActionHandler inlineActionHandler;

    public JiraInlineActionResource(JiraInlineActionHandler inlineActionHandler) {
        this.inlineActionHandler = (JiraInlineActionHandler)Preconditions.checkNotNull((Object)inlineActionHandler, (Object)"inlineActionHandler");
    }

    @Path(value="issue-watch/{issueKey}")
    @Consumes(value={"application/json"})
    @POST
    public Response watchIssue(@PathParam(value="issueKey") String issueKey) {
        if (this.inlineActionHandler.hasPreviouslyWatched(issueKey)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        boolean success = this.inlineActionHandler.startWatching(issueKey);
        if (success) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
    }

    @Path(value="issue-watch/{issueKey}")
    @Produces(value={"application/json"})
    @GET
    public boolean isWatching(@PathParam(value="issueKey") String issueKey) {
        return this.inlineActionHandler.hasPreviouslyWatched(issueKey);
    }

    @Path(value="issue-vote/{issueKey}")
    @Consumes(value={"application/json"})
    @POST
    public Response voteIssue(@PathParam(value="issueKey") String issueKey) {
        if (this.inlineActionHandler.hasPreviouslyVoted(issueKey)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        boolean success = this.inlineActionHandler.voteOnIssue(issueKey);
        if (success) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
    }
}

