/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.renderer;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Fold;
import com.atlassian.streams.api.common.Function2;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.UriProvider;
import com.atlassian.streams.jira.renderer.IssueActivityObjectRendererFactory;
import com.atlassian.streams.jira.util.RenderingUtilities;
import com.atlassian.streams.spi.renderer.Renderers;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Dimension;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentRendererFactory {
    private static final Logger log = LoggerFactory.getLogger(AttachmentRendererFactory.class);
    private static final Dimension BROKEN_THUMBNAIL_DIMENSION = new Dimension(48, 48);
    private final I18nResolver i18nResolver;
    private final ThumbnailManager thumbnailManager;
    private final StreamsEntryRendererFactory rendererFactory;
    private final IssueActivityObjectRendererFactory issueActivityObjectRendererFactory;
    private final TemplateRenderer templateRenderer;
    private final UriProvider uriProvider;
    private final JiraHelper helper;

    AttachmentRendererFactory(I18nResolver i18nResolver, ThumbnailManager thumbnailManager, StreamsEntryRendererFactory rendererFactory, IssueActivityObjectRendererFactory issueActivityObjectRendererFactory, TemplateRenderer templateRenderer, UriProvider uriProvider, JiraHelper helper) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.thumbnailManager = (ThumbnailManager)Preconditions.checkNotNull((Object)thumbnailManager, (Object)"thumbnailManager");
        this.rendererFactory = (StreamsEntryRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.issueActivityObjectRendererFactory = (IssueActivityObjectRendererFactory)Preconditions.checkNotNull((Object)issueActivityObjectRendererFactory, (Object)"issueActivityObjectRendererFactory");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.uriProvider = (UriProvider)Preconditions.checkNotNull((Object)uriProvider, (Object)"uriProvider");
    }

    public StreamsEntry.Renderer newAttachmentsEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<Attachment> attachments) {
        return new AttachmentsEntryRenderer(item, baseUri, attachments);
    }

    public Function<Iterable<Attachment>, Html> newAttachmentsRenderer(JiraActivityItem item, URI baseUri) {
        return new AttachmentListRenderer(item, baseUri, true);
    }

    public Function<Iterable<Attachment>, Html> newAttachmentsRendererWithoutComment(JiraActivityItem item, URI baseUri) {
        return new AttachmentListRenderer(item, baseUri, false);
    }

    private Function<Attachment, AttachmentItem> asAttachmentItem(final URI baseUri) {
        return new Function<Attachment, AttachmentItem>(){

            public AttachmentItem apply(Attachment attachment) {
                return new AttachmentItem(AttachmentRendererFactory.this.uriProvider.getAttachmentUri(baseUri, attachment), attachment.getFilename());
            }
        };
    }

    private Function<Attachment, ThumbnailItem> asThumbnailItem(final URI baseUri) {
        return new Function<Attachment, ThumbnailItem>(){

            public ThumbnailItem apply(@Nullable Attachment attachment) {
                return (ThumbnailItem)Option.option((Object)AttachmentRendererFactory.this.thumbnailManager.getThumbnail(attachment)).map(AttachmentRendererFactory.this.mkThumbnailItem(attachment, baseUri)).getOrElse((Object)AttachmentRendererFactory.this.brokenThumbnailItem(attachment, baseUri));
            }
        };
    }

    private Function<Thumbnail, ThumbnailItem> mkThumbnailItem(final Attachment attachment, final URI baseUri) {
        return new Function<Thumbnail, ThumbnailItem>(){

            public ThumbnailItem apply(Thumbnail thumbnail) {
                if (thumbnail.getFilename() == null) {
                    return AttachmentRendererFactory.this.brokenThumbnailItem(attachment, baseUri);
                }
                return new ThumbnailItem(AttachmentRendererFactory.this.uriProvider.getThumbnailUri(baseUri, thumbnail), AttachmentRendererFactory.this.uriProvider.getAttachmentUri(baseUri, attachment), RenderingUtilities.scaleToThumbnailSize(thumbnail.getWidth(), thumbnail.getHeight()));
            }
        };
    }

    private ThumbnailItem brokenThumbnailItem(Attachment attachment, URI baseUri) {
        return new ThumbnailItem(this.uriProvider.getBrokenThumbnailUri(baseUri), this.uriProvider.getAttachmentUri(baseUri, attachment), BROKEN_THUMBNAIL_DIMENSION);
    }

    public static class ThumbnailItem {
        private final URI uri;
        private final URI attachmentUri;
        private final Dimension dim;

        ThumbnailItem(URI uri, URI attachmentUri, Dimension dim) {
            this.uri = uri;
            this.attachmentUri = attachmentUri;
            this.dim = dim;
        }

        public URI getUri() {
            return this.uri;
        }

        public URI getAttachmentUri() {
            return this.attachmentUri;
        }

        public int getWidth() {
            return (int)this.dim.getWidth();
        }

        public int getHeight() {
            return (int)this.dim.getHeight();
        }
    }

    public static class AttachmentItem {
        private final URI uri;
        private final String filename;

        AttachmentItem(URI uri, String filename) {
            this.uri = uri;
            this.filename = filename;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    private final class AttachmentsEntryRenderer
    implements StreamsEntry.Renderer {
        private final Iterable<Attachment> attachments;
        private final Function<Iterable<UserProfile>, Html> authorsRenderer;
        private final Function<StreamsEntry.ActivityObject, Option<Html>> targetRenderer;
        private final Function<Iterable<Attachment>, Html> attachmentsRenderer;

        public AttachmentsEntryRenderer(JiraActivityItem item, URI baseUri, Iterable<Attachment> attachments) {
            this.attachments = attachments;
            this.attachmentsRenderer = AttachmentRendererFactory.this.newAttachmentsRenderer(item, baseUri);
            this.authorsRenderer = AttachmentRendererFactory.this.rendererFactory.newAuthorsRenderer();
            this.targetRenderer = AttachmentRendererFactory.this.issueActivityObjectRendererFactory.newIssueActivityObjectRendererWithSummary(item.getIssue());
        }

        public Option<Html> renderContentAsHtml(StreamsEntry entry) {
            return Option.some(this.attachments).map(this.attachmentsRenderer);
        }

        public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
            return Option.none();
        }

        public Html renderTitleAsHtml(StreamsEntry entry) {
            return new Html(AttachmentRendererFactory.this.i18nResolver.getText("streams.item.jira.title.attached", new Serializable[]{(Serializable)this.authorsRenderer.apply((Object)entry.getAuthors()), Integer.valueOf(Iterables.size(this.attachments)), (Serializable)((Option)this.targetRenderer.apply(entry.getTarget().get())).get()}));
        }
    }

    private final class AttachmentListRenderer
    implements Function<Iterable<Attachment>, Html> {
        private final JiraActivityItem item;
        private final boolean withComment;
        private final URI baseUri;
        private final Function2<Attachment, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>> splitAttachments = new Function2<Attachment, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>>(){

            public Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>> apply(Attachment attachment, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>> acc) {
                try {
                    if (AttachmentRendererFactory.this.thumbnailManager.isThumbnailable(attachment)) {
                        return Pair.pair((Object)acc.first(), (Object)Iterables.concat((Iterable)((Iterable)acc.second()), (Iterable)ImmutableList.of((Object)attachment)));
                    }
                }
                catch (Exception e) {
                    log.error("Error getting thumbnail for attachment", (Throwable)e);
                }
                return Pair.pair((Object)Iterables.concat((Iterable)((Iterable)acc.first()), (Iterable)ImmutableList.of((Object)attachment)), (Object)acc.second());
            }
        };

        public AttachmentListRenderer(JiraActivityItem item, URI baseUri, boolean withComment) {
            this.item = (JiraActivityItem)Preconditions.checkNotNull((Object)item, (Object)"item");
            this.withComment = withComment;
            this.baseUri = baseUri;
        }

        public Html apply(Iterable<Attachment> attachments) {
            Pair init = Pair.pair((Object)ImmutableList.of(), (Object)ImmutableList.of());
            Pair items = (Pair)Fold.foldl(attachments, (Object)init, this.splitAttachments());
            return new Html(Renderers.render((TemplateRenderer)AttachmentRendererFactory.this.templateRenderer, (String)"attachment-list.vm", (Map)ImmutableMap.of((Object)"comment", (Object)(this.withComment ? this.item.getComment().map(AttachmentRendererFactory.this.helper.renderComment()).flatMap(Html.trimHtmlToNone()) : Option.none()), (Object)"attachments", (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)items.first()), (Function)AttachmentRendererFactory.this.asAttachmentItem(this.baseUri))), (Object)"thumbnails", (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)items.second()), (Function)AttachmentRendererFactory.this.asThumbnailItem(this.baseUri))))));
        }

        private Function2<Attachment, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>, Pair<? extends Iterable<Attachment>, ? extends Iterable<Attachment>>> splitAttachments() {
            return this.splitAttachments;
        }
    }
}

