/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira.builder;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityVerbs;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.renderer.IssueTransitionRendererFactory;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;
import org.ofbiz.core.entity.GenericValue;

class StatusChangeEntryBuilder {
    private final JiraHelper helper;
    private final IssueTransitionRendererFactory rendererFactory;
    private final StreamsI18nResolver i18nResolver;

    StatusChangeEntryBuilder(JiraHelper helper, IssueTransitionRendererFactory rendererFactory, StreamsI18nResolver i18nResolver) {
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.rendererFactory = (IssueTransitionRendererFactory)Preconditions.checkNotNull((Object)rendererFactory, (Object)"rendererFactory");
        this.i18nResolver = (StreamsI18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
    }

    Option<StreamsEntry> build(JiraActivityItem item, URI baseUri, GenericValue change) {
        ActivityVerb verb = (ActivityVerb)item.getActivity().second();
        if (JiraActivityVerbs.resolve().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "resolved", verb);
        }
        if (JiraActivityVerbs.close().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "closed", verb);
        }
        if (JiraActivityVerbs.reopen().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "reopened", verb);
        }
        if (JiraActivityVerbs.open().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "opened", verb);
        }
        if (JiraActivityVerbs.stop().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "stopped", verb);
        }
        if (JiraActivityVerbs.start().equals(verb)) {
            return this.newEntryForStatus(item, baseUri, "started", verb);
        }
        Iterator iterator = this.helper.getNewChangeItemNameTranslation(change).iterator();
        if (iterator.hasNext()) {
            String statusName = (String)iterator.next();
            return Option.some((Object)new StreamsEntry(this.helper.newBuilder(item, baseUri).authors(this.helper.getUserProfiles(baseUri, item)).categories((Iterable)ImmutableList.of((Object)statusName)).verb(JiraActivityVerbs.transition()).addActivityObject(this.helper.buildActivityObject(item.getIssue(), baseUri, item.getDisplaySummary())).renderer(this.rendererFactory.newCustomTransitionRenderer(item, baseUri, statusName)), (I18nResolver)this.i18nResolver));
        }
        return Option.none();
    }

    private Option<StreamsEntry> newEntryForStatus(JiraActivityItem item, URI baseUri, String status, ActivityVerb verb) {
        StreamsEntry.Renderer renderer = JiraActivityVerbs.resolve().equals(verb) ? this.rendererFactory.newResolvedRenderer(item, baseUri) : this.rendererFactory.newSystemTransitionRenderer(item, baseUri, verb);
        return Option.some((Object)new StreamsEntry(this.helper.newBuilder(item, baseUri).authors(this.helper.getUserProfiles(baseUri, item)).categories((Iterable)ImmutableList.of((Object)status)).verb(verb).addActivityObject(this.helper.buildActivityObject(item.getIssue(), baseUri, item.getDisplaySummary())).renderer(renderer), (I18nResolver)this.i18nResolver));
    }
}

