/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.common.Iterables;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.common.Suppliers;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.IssueActivityExtractor;
import com.atlassian.streams.jira.JiraActivityItem;
import com.atlassian.streams.jira.JiraActivityItemAggregator;
import com.atlassian.streams.jira.JiraEntryFactory;
import com.atlassian.streams.jira.JiraHelper;
import com.atlassian.streams.jira.changehistory.IssueHistory;
import com.atlassian.streams.jira.changehistory.IssueHistoryReader;
import com.atlassian.streams.jira.search.IssueFinder;
import com.atlassian.streams.jira.util.RenderingUtilities;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.CancelledException;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class JiraStreamsActivityProvider
implements StreamsActivityProvider {
    static final long CLOSE_ENOUGH_TIME_LIMIT_MS = 200L;
    public static final String PROVIDER_KEY = "issues";
    public static final String ISSUE_VOTE_REL = "http://streams.atlassian.com/syndication/issue-vote";
    private final JiraAuthenticationContext authenticationContext;
    private final CommentManager commentManager;
    private final JiraHelper helper;
    private final JiraActivityItemAggregator jiraActivityItemAggregator;
    private final JiraEntryFactory jiraEntryFactory;
    private final ApplicationProperties jiraApplicationProperties;
    private final IssueFinder issueFinder;
    private final IssueHistoryReader issueHistoryReader;
    private static final Ordering<JiraActivityItem> orderByDate = new Ordering<JiraActivityItem>(){

        public int compare(JiraActivityItem item1, JiraActivityItem item2) {
            return item2.getDate().compareTo(item1.getDate());
        }
    };

    public JiraStreamsActivityProvider(JiraAuthenticationContext authenticationContext, CommentManager commentManager, JiraHelper helper, JiraActivityItemAggregator jiraActivityItemAggregator, JiraEntryFactory jiraSyndEntryFactory, ApplicationProperties jiraApplicationProperties, IssueFinder issueFinder, IssueHistoryReader issueHistoryReader) {
        this.authenticationContext = authenticationContext;
        this.commentManager = commentManager;
        this.helper = (JiraHelper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.jiraActivityItemAggregator = (JiraActivityItemAggregator)Preconditions.checkNotNull((Object)jiraActivityItemAggregator, (Object)"jiraActivityItemAggregator");
        this.jiraEntryFactory = jiraSyndEntryFactory;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.issueFinder = (IssueFinder)Preconditions.checkNotNull((Object)issueFinder, (Object)"issueFinder");
        this.issueHistoryReader = (IssueHistoryReader)Preconditions.checkNotNull((Object)issueHistoryReader, (Object)"issueHistoryReader");
    }

    public CancellableTask<StreamsFeed> getActivityFeed(final ActivityRequest request) throws StreamsException {
        return new CancellableTask<StreamsFeed>(){
            final AtomicBoolean cancelled = new AtomicBoolean(false);

            public StreamsFeed call() throws Exception {
                Set<Issue> issues = JiraStreamsActivityProvider.this.issueFinder.find(request);
                List activityItems = orderByDate.sortedCopy((Iterable)JiraStreamsActivityProvider.this.extractActivity(issues, request, (Supplier<Boolean>)Suppliers.forAtomicBoolean((AtomicBoolean)this.cancelled)));
                Iterable<AggregatedJiraActivityItem> activities = JiraStreamsActivityProvider.this.jiraActivityItemAggregator.aggregate(activityItems);
                Iterable<StreamsEntry> entries = JiraStreamsActivityProvider.this.jiraEntryFactory.getEntries(activities, request);
                String title = RenderingUtilities.htmlEncode(JiraStreamsActivityProvider.this.jiraApplicationProperties.getDefaultBackedString("jira.title") + " - " + JiraStreamsActivityProvider.this.authenticationContext.getI18nHelper().getText("portlet.activityfeed.name"));
                return new StreamsFeed(title, Iterables.take((int)request.getMaxResults(), entries), Option.none(String.class));
            }

            public CancellableTask.Result cancel() {
                this.cancelled.set(true);
                return CancellableTask.Result.CANCELLED;
            }
        };
    }

    private List<JiraActivityItem> extractActivity(Iterable<Issue> issues, ActivityRequest request, Supplier<Boolean> cancelled) {
        ApplicationUser user = this.authenticationContext.getUser();
        Predicate inUsers = Filters.inUsers((ActivityRequest)request);
        Predicate containsDate = Filters.inDateRange((ActivityRequest)request);
        Predicate hasActivity = Options.isDefined();
        Predicate inJiraActivities = Filters.inActivities((ActivityRequest)request);
        ImmutableList.Builder builder = ImmutableList.builder();
        ChangeHistoryQuery changeHistories = new ChangeHistoryQuery(this.issueHistoryReader, issues, user);
        IssueActivityExtractor issueActivityExtractor = new IssueActivityExtractor(user, this.commentManager, this.helper, (ImmutableList.Builder<JiraActivityItem>)builder, changeHistories, (Predicate<String>)inUsers, (Predicate<Date>)containsDate, (Predicate<Pair<ActivityObjectType, ActivityVerb>>)inJiraActivities);
        for (Issue issue : issues) {
            if (((Boolean)cancelled.get()).booleanValue()) {
                throw new CancelledException();
            }
            issueActivityExtractor.extract(issue);
        }
        return builder.build();
    }

    static class ChangeHistoryQuery {
        private IssueHistoryReader issueHistoryReader;
        private ImmutableMap<Issue, IssueHistory> queryResults;
        private static final Ordering<ChangeHistory> orderChangeHistoryByDate = new Ordering<ChangeHistory>(){

            public int compare(ChangeHistory item1, ChangeHistory item2) {
                return item1.getTimePerformed().compareTo(item2.getTimePerformed());
            }
        };

        private ChangeHistoryQuery(IssueHistoryReader issueHistoryReader, Iterable<Issue> issues, ApplicationUser user) {
            this.issueHistoryReader = issueHistoryReader;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (IssueHistory issueHistory : issueHistoryReader.getChangeHistoriesForUser(issues, user)) {
                builder.put((Object)issueHistory.issue(), (Object)issueHistory);
            }
            this.queryResults = builder.build();
        }

        ImmutableCollection<ChangeHistory> changeHistories(Issue issue) {
            if (!this.queryResults.containsKey((Object)issue)) {
                return ImmutableList.of();
            }
            return ((IssueHistory)this.queryResults.get((Object)issue)).changeHistories();
        }

        List<ChangeHistory> sortedChangeHistories(Issue issue) {
            return orderChangeHistoryByDate.sortedCopy(this.changeHistories(issue));
        }
    }
}

