/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.streams.spi.FormatPreferenceProvider;
import com.google.common.base.Preconditions;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;

public class JiraFormatPreferenceProvider
implements FormatPreferenceProvider {
    private final DateTimeFormatterFactory formatterFactory;
    private final TimeZoneManager timeZoneManager;
    private final ApplicationProperties applicationProperties;

    public JiraFormatPreferenceProvider(DateTimeFormatterFactory formatterFactory, TimeZoneManager timeZoneManager, ApplicationProperties applicationProperties) {
        this.formatterFactory = (DateTimeFormatterFactory)Preconditions.checkNotNull((Object)formatterFactory, (Object)"formatterFactory");
        this.timeZoneManager = (TimeZoneManager)Preconditions.checkNotNull((Object)timeZoneManager, (Object)"timeZoneManager");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    public String getTimeFormatPreference() {
        return this.formatterFactory.formatter().withStyle(DateTimeStyle.TIME).getFormatHint();
    }

    public String getDateFormatPreference() {
        return this.formatterFactory.formatter().withStyle(DateTimeStyle.DATE).getFormatHint();
    }

    public String getDateTimeFormatPreference() {
        return this.formatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).getFormatHint();
    }

    public boolean getDateRelativizePreference() {
        return Boolean.parseBoolean(this.applicationProperties.getDefaultBackedText("jira.lf.date.relativize"));
    }

    public DateTimeZone getUserTimeZone() {
        try {
            return DateTimeZone.forTimeZone((TimeZone)this.timeZoneManager.getUserTimeZone());
        }
        catch (IllegalArgumentException e) {
            return DateTimeZone.getDefault();
        }
    }
}

