/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.AggregatedJiraActivityItem;
import com.atlassian.streams.jira.JiraActivityObjectTypes;
import com.atlassian.streams.jira.JiraEntryFactory;
import com.atlassian.streams.jira.builder.ChangeEntryBuilder;
import com.atlassian.streams.jira.builder.CommentEntryBuilder;
import com.atlassian.streams.jira.builder.CreatedEntryBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraEntryFactoryImpl
implements JiraEntryFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraEntryFactoryImpl.class);
    private final CreatedEntryBuilder createdEntryBuilder;
    private final ChangeEntryBuilder changeEntryBuilder;
    private final CommentEntryBuilder commentEntryBuilder;

    public JiraEntryFactoryImpl(CreatedEntryBuilder createdEntryBuilder, ChangeEntryBuilder changeEntryBuilder, CommentEntryBuilder commentEntryBuilder) {
        this.createdEntryBuilder = (CreatedEntryBuilder)Preconditions.checkNotNull((Object)createdEntryBuilder, (Object)"createdEntryBuilder");
        this.changeEntryBuilder = (ChangeEntryBuilder)Preconditions.checkNotNull((Object)changeEntryBuilder, (Object)"changeEntryBuilder");
        this.commentEntryBuilder = (CommentEntryBuilder)Preconditions.checkNotNull((Object)commentEntryBuilder, (Object)"commentEntryBuilder");
    }

    @Override
    public Iterable<StreamsEntry> getEntries(Iterable<AggregatedJiraActivityItem> items, ActivityRequest request) {
        return Options.catOptions((Iterable)Iterables.transform(items, this.toStreamsEntries(request)));
    }

    private Function<AggregatedJiraActivityItem, Option<StreamsEntry>> toStreamsEntries(final ActivityRequest request) {
        return new Function<AggregatedJiraActivityItem, Option<StreamsEntry>>(){

            public Option<StreamsEntry> apply(AggregatedJiraActivityItem item) {
                try {
                    if (this.isIssueCreation(item)) {
                        return JiraEntryFactoryImpl.this.createdEntryBuilder.build(item.getActivityItem(), request);
                    }
                    if (this.isPostComment(item)) {
                        return JiraEntryFactoryImpl.this.commentEntryBuilder.build(item.getActivityItem(), request);
                    }
                    return JiraEntryFactoryImpl.this.changeEntryBuilder.build(item, request);
                }
                catch (Exception e) {
                    log.warn("Error creating streams entry", (Throwable)e);
                    return Option.none(StreamsEntry.class);
                }
            }

            private boolean isPostComment(AggregatedJiraActivityItem item) {
                return Pair.pair((Object)ActivityObjectTypes.comment(), (Object)ActivityVerbs.post()).equals(item.getActivity());
            }

            private boolean isIssueCreation(AggregatedJiraActivityItem item) {
                return Pair.pair((Object)JiraActivityObjectTypes.issue(), (Object)ActivityVerbs.post()).equals(item.getActivity());
            }
        };
    }
}

