/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.jira.JiraActivityItem;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public final class ChangeItems {
    private static final Iterable<String> FIELDS_TO_SKIP = ImmutableSet.of((Object)"projectimport", (Object)"workflow", (Object)"worklogid");
    private static final Predicate<GenericValue> displayable = new Predicate<GenericValue>(){

        public boolean apply(GenericValue item) {
            return !Iterables.contains((Iterable)FIELDS_TO_SKIP, (Object)item.getString("field").toLowerCase());
        }
    };

    private ChangeItems() {
    }

    public static Iterable<GenericValue> getChangeItems(JiraActivityItem item) {
        Iterator iterator = item.getChangeHistory().iterator();
        if (iterator.hasNext()) {
            ChangeHistory history = (ChangeHistory)iterator.next();
            return ChangeItems.getChangeItems(history);
        }
        return ImmutableList.of();
    }

    public static Iterable<GenericValue> getChangeItems(ChangeHistory history) {
        return Iterables.filter(ChangeItems.getUnfilteredChangeItems(history), displayable);
    }

    public static GenericValue getFirstChangeItem(JiraActivityItem item) {
        return (GenericValue)Iterables.get(ChangeItems.getChangeItems(item), (int)0);
    }

    public static Option<Long> getWorklogId(JiraActivityItem item) {
        for (ChangeHistory history : item.getChangeHistory()) {
            for (GenericValue changeItem : ChangeItems.getUnfilteredChangeItems(history)) {
                String newValue;
                if (!"worklogid".equalsIgnoreCase(changeItem.getString("field")) || StringUtils.isBlank((String)(newValue = changeItem.getString("oldvalue")))) continue;
                return Option.some((Object)Long.parseLong(newValue));
            }
        }
        return Option.none();
    }

    private static Iterable<GenericValue> getUnfilteredChangeItems(ChangeHistory changeHistory) {
        return changeHistory.getChangeItems();
    }

    public static int updatedFieldCount(Iterable<GenericValue> changeItems) {
        int count = 0;
        boolean attachmentCounted = false;
        for (GenericValue changeItem : changeItems) {
            if (ChangeItems.isAttachment(changeItem)) {
                if (!attachmentCounted) {
                    ++count;
                }
                attachmentCounted = true;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static boolean isAttachment(GenericValue v) {
        return ChangeItems.isAttachment().apply((Object)v);
    }

    public static Predicate<GenericValue> isAttachment() {
        return IsAttachment.INSTANCE;
    }

    public static Predicate<GenericValue> isStatusUpdate() {
        return Predicates.and((Predicate)IsSystemField.INSTANCE, (Predicate)IsStatusUpdate.INSTANCE);
    }

    public static boolean isStatusUpdate(GenericValue gv) {
        return ChangeItems.isStatusUpdate().apply((Object)gv);
    }

    public static Predicate<GenericValue> isLinkUpdate() {
        return Predicates.and((Predicate)IsSystemField.INSTANCE, (Predicate)IsLinkUpdate.INSTANCE);
    }

    public static boolean isLinkUpdate(GenericValue gv) {
        return ChangeItems.isLinkUpdate().apply((Object)gv);
    }

    public static boolean isRemoteLinkUpdate(GenericValue v) {
        return ChangeItems.isRemoteLinkUpdate().apply((Object)v);
    }

    public static Predicate<GenericValue> isRemoteLinkUpdate() {
        return IsRemoteLinkUpdate.INSTANCE;
    }

    public static Predicate<GenericValue> isDeletedComment() {
        return Predicates.and((Predicate)IsSystemField.INSTANCE, (Predicate)IsDeletedComment.INSTANCE);
    }

    private static enum IsDeletedComment implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue gv) {
            return gv.getString("field").equalsIgnoreCase("comment") && StringUtils.isBlank((String)gv.getString("newvalue"));
        }
    }

    private static enum IsRemoteLinkUpdate implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue v) {
            return "remoteissuelink".equalsIgnoreCase(v.getString("field"));
        }
    }

    private static enum IsLinkUpdate implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue gv) {
            return "link".equalsIgnoreCase(gv.getString("field"));
        }
    }

    private static enum IsStatusUpdate implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue gv) {
            return "status".equalsIgnoreCase(gv.getString("field"));
        }
    }

    private static enum IsSystemField implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue gv) {
            return "jira".equalsIgnoreCase(gv.getString("fieldtype"));
        }
    }

    private static enum IsAttachment implements Predicate<GenericValue>
    {
        INSTANCE;


        public boolean apply(GenericValue v) {
            return "attachment".equalsIgnoreCase(v.getString("field"));
        }
    }
}

