/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.jira;

import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.jira.JiraActivityItem;
import com.google.common.base.Preconditions;

public class AggregatedJiraActivityItem {
    private final JiraActivityItem item;
    private final Option<Iterable<JiraActivityItem>> relatedActivityItems;
    private final Pair<ActivityObjectType, ActivityVerb> activity;

    public AggregatedJiraActivityItem(JiraActivityItem item) {
        this.item = (JiraActivityItem)Preconditions.checkNotNull((Object)item, (Object)"item");
        this.relatedActivityItems = Option.none();
        this.activity = item.getActivity();
    }

    public AggregatedJiraActivityItem(JiraActivityItem item, Iterable<JiraActivityItem> relatedActivityItems, Pair<ActivityObjectType, ActivityVerb> activity) {
        this.item = (JiraActivityItem)Preconditions.checkNotNull((Object)item, (Object)"item");
        this.relatedActivityItems = Option.option(relatedActivityItems);
        this.activity = (Pair)Preconditions.checkNotNull(activity, (Object)"activity");
    }

    public Option<Iterable<JiraActivityItem>> getRelatedActivityItems() {
        return this.relatedActivityItems;
    }

    public Pair<ActivityObjectType, ActivityVerb> getActivity() {
        return this.activity;
    }

    public JiraActivityItem getActivityItem() {
        return this.item;
    }
}

