/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.internal.feed;

import com.atlassian.streams.api.FeedContentSanitizer;
import java.net.URL;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedContentSanitizerImpl
implements FeedContentSanitizer {
    private static final Logger log = LoggerFactory.getLogger(FeedContentSanitizerImpl.class);
    public static final String ANTISAMY_POLICY_FILE = "antisamy-policy.xml";
    private URL policyUrl = this.getClass().getClassLoader().getResource("antisamy-policy.xml");
    private AntiSamy as = new AntiSamy();
    private Policy policy;

    public FeedContentSanitizerImpl() {
        try {
            this.policy = Policy.getInstance(this.policyUrl);
        }
        catch (PolicyException e) {
            log.error("Error loading AntiSamy policy file", (Throwable)e);
        }
    }

    public String sanitize(String taintedInput) {
        CleanResults cr;
        try {
            cr = this.as.scan(taintedInput, this.policy);
        }
        catch (PolicyException e) {
            log.error("Error loading AntiSamy policy file", (Throwable)e);
            return "";
        }
        catch (ScanException e) {
            log.debug("Error scanning input with AntiSamy", (Throwable)e);
            return "";
        }
        return cr.getCleanHTML();
    }
}

