/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.common.renderer;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Options;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;

final class CompoundStatementRenderer<T>
implements Function<Iterable<T>, Option<Html>> {
    private final I18nResolver i18nResolver;
    private final Function<T, Option<Html>> render;

    public CompoundStatementRenderer(I18nResolver i18nResolver, Function<T, Option<Html>> render) {
        this.i18nResolver = i18nResolver;
        this.render = render;
    }

    public Option<Html> apply(Iterable<T> xs) {
        ImmutableList rendered = ImmutableList.copyOf((Iterable)Options.catOptions((Iterable)Iterables.transform(xs, this.render)));
        if (Iterables.isEmpty((Iterable)rendered)) {
            return Option.none();
        }
        int numRendered = Iterables.size((Iterable)rendered);
        if (numRendered == 1) {
            return Option.some((Object)Iterables.get((Iterable)rendered, (int)0));
        }
        Iterator partitions = Iterables.partition((Iterable)rendered, (int)(numRendered - 1)).iterator();
        Iterable allButLast = (Iterable)partitions.next();
        Iterable last = (Iterable)partitions.next();
        return Option.some((Object)new Html(Joiner.on((String)", ").join(allButLast) + " " + this.i18nResolver.getText("streams.and") + " " + Iterables.get((Iterable)last, (int)0)));
    }
}

