function pollForProgress(url, idPrefix, delay) {
    "use strict";
    AJS.$.ajax({
        async: "true",
        cacheBoolean: "false",
        dataType: "html",
        error: function (XMLHttpRequest, textStatus, errorThrown) { },
        success: function (data, textStatus, XMLHttpRequest) {
            if (data) {
                var jsonData = JSON.parse(data);
                AJS.$("#" + idPrefix + "-in-progress-message").text(jsonData.progressMessage);

                var inProgress = AJS.$("#" + idPrefix + "-in-progress");
                inProgress.find(".stp-progress-amount").css("width", jsonData.progressPercentage + "%");
                inProgress.find(".stp-progress-bar-percent").html(jsonData.progressPercentage);

                setMessages(jsonData.errors, AJS.$("#" + idPrefix + "-errors"));
                setMessages(jsonData.warnings, AJS.$("#" + idPrefix + "-warnings"));

                if (jsonData.available) {
                    AJS.$("#" + idPrefix + "-in-progress").hide();

                    // Display the start again form once the request is completed
                    AJS.$("#" + idPrefix + "-start-again").show();

                    if (!jsonData.errors) {
                        var doneMessage = AJS.$("#" + idPrefix + "-done-message");
                        if (doneMessage) {
                            doneMessage.text(jsonData.progressMessage);
                        }

                        if (idPrefix === "stp-request") {
                            // Remove the cached form content from local storage once the create support request has been successfully submitted
                            localStorage.removeItem("stp-create-support-request-form-data");
                        }

                        AJS.$("#" + idPrefix + "-done").show();
                    } else {
                        // Display a different link text if there's an error occurred when sending the support request
                        AJS.$("#start-again-link").text(AJS.I18n.getText("stp.create.support.request.error.back.to.form"));
                    }

                    return;
                }
            }
            setTimeout(function() { pollForProgress(url, idPrefix, delay) }, delay * 1000);
        },
        timeout: 10000,
        type: "GET",
        url: url
    });
}

function setMessages(messageArr, messageContainer) {
    "use strict";
    if (messageArr && messageArr.length > 0) {
        var ulElem = messageContainer.find("ul");
        ulElem.empty();
        messageArr.map(function (message) {
            ulElem.append('<li>' + message.body + '</li>');
        });
        messageContainer.show();
    } else {
        messageContainer.hide();
    }
}

function createSupportRequestFormData(url, currentUser) {
    var formData = localStorage.getItem("stp-create-support-request-form-data");

    if (formData == null) {
        // Initialize the form data cache into local storage if existing data is not present
        initFormDataFunction(url);
    } else {
        var jsonData = JSON.parse(formData);

        var url = jsonData["requestUrl"];
        var contactEmail = jsonData["contactEmail"];

        // If base URL or contact email is undefined, we display the option for user to restore previous content
        // This is handy for testing, where multiple product based doesn't have specific base URL or admin email address
        if ((typeof url === 'undefined' || url === url) &&
            (typeof contactEmail === 'undefined' || contactEmail === currentUser)) {
            var banner = AJS.messages.generic({
                id: 'create-request-form-content-message',
                body: AJS.I18n.getText('stp.create.support.request.cache.desc',
                    '<a href=\'#\' id=\'restore-content\'>restore</a>',
                    '<a href=\'#\' id=\'discard-content\'>discard</a>'),
                closeable: false
            });

            var $form = AJS.$("#form-create-support-request");
            $form.prepend(banner);

            AJS.$("#restore-content").on('click', function(event) {
                removeBannerFromPage(banner, event);

                var subject = jsonData["subject"];
                var description = jsonData["description"];

                if (!(typeof contactEmail === 'undefined')) {
                    AJS.$("#form-create-support-request input[name=contactEmail]").val(contactEmail);
                }
                if (!(typeof subject === 'undefined')) {
                    AJS.$("#form-create-support-request input[name=subject]").val(subject);
                }
                if (!(typeof description === 'undefined')) {
                    AJS.$("#form-create-support-request textarea[name=description]").val(description);
                }

                AJS.trigger('analyticsEvent', { name: ('stp.create.support.request.form.restored')} );

                // Initialize the form data cache after restoring the previous content
                initFormDataFunction(url);
            });

            AJS.$("#discard-content").on('click', function(event) {
                removeBannerFromPage(banner, event);
                localStorage.removeItem("stp-create-support-request-form-data");
                // Initialize the form data cache after the previous content is discarded
                initFormDataFunction(url);
            });
        }
    }
}

// The function to remove the restore content banner by sliding up (animation) then remove it from DOM
function removeBannerFromPage(banner, event) {
    event.preventDefault();
    banner.slideUp("normal", function() {
        AJS.$(this).remove();
    });
}

function initFormDataFunction(url) {
    // Store the value of the create request form to browser local storage every 3 seconds
    var delay = 3 * 1000;
    setTimeout(function() { storeFormData(delay, url); }, delay);
}

function storeFormData(delay, url) {
    var $form = AJS.$("#form-create-support-request");
    var formArray = $form.serializeArray();

    var formData = {};
    var shouldStoreContent = false;

    for (var count = 0; count < formArray.length; count++) {
        var name = formArray[count].name;
        // Only store the value of the Contact Email, Summary and Description of the problem
        if (name === "contactEmail" || name === "subject" || name === "description") {
            var value = formArray[count].value;

            if (value != "") {
                formData[name] = value;

                if (name === "description" || name === "subject") {
                    // Set the should store flag to true if subject or description is not empty
                    shouldStoreContent = true;
                }
            }
        }
    }

    // Only save content if description or subject has some value in it
    if (shouldStoreContent) {
        formData["requestUrl"] = url;
        localStorage.setItem("stp-create-support-request-form-data", JSON.stringify(formData));
    }

    // From here onwards, we call the function to store the data into local storage in loop, based on the delay set
    setTimeout(function() {
        storeFormData(delay, url)
    }, delay);
}

function attachSmtpMailBannerAnalytics() {
    // When any of the element inside the banner is clicked, we check if any of the link was clicked and if yes, trigger the analytics event
    AJS.$("#outgoing-mail-server-needed-reminder").on('click', function(e) {
        const SmtpBannerEvents = {
            mail_server_link : "stp.create.support.request.mail-server-link.clicked",
            support_link : "stp.create.support.request.support-link.clicked",
            support_zip_link : "stp.create.support.request.support-zip-link.clicked"
        };

        var eventName = e.target.getAttribute('data-event-name');

        for (var event in SmtpBannerEvents) {
            if (eventName == event || eventName == event || eventName == event) {
                AJS.trigger('analyticsEvent', {name: SmtpBannerEvents[eventName]});
                break;
            }
        }
    });
}