(function ($) {
    var LicenseStatus =
    {
        destroyBanner: function () {
            AJS.$("#stp-licenseStatus-banner").slideUp(function () {
                AJS.$("#stp-licenseStatus-banner").remove();
                AJS.trigger('stp-licenseStatus-banner:destroyed');
            });
        },

        remindMeNever: function (e) {
            e.preventDefault();
            AJS.$.ajax(
                    {
                        type: "POST",
                        async: true,
                        headers: {
                            "X-Atlassian-Token": "no-check"
                        },
                        url: AJS.contextPath() + "/rest/stp/1.0/license/remindMeNever"
                    });
            LicenseStatus.destroyBanner();
        },

        remindMeLater: function () {
            AJS.$.ajax(
                    {
                        type: "POST",
                        async: true,
                        headers: {
                            "X-Atlassian-Token": "no-check"
                        },
                        url: AJS.contextPath() + "/rest/stp/1.0/license/remindMeLater"
                    });
            LicenseStatus.destroyBanner();
        },

        createBanner: function ( daysToExpiry, productName) {
            var banner = "\n<div id='stp-licenseStatus-banner' class='aui-message warning'>\n";
            var renewLink = "https://www.atlassian.com/purchase/renew?utm_source=STP&utm_medium=renewals_reminder&utm_campaign=renewals_reminder";

            if(daysToExpiry === 0) {
                banner += AJS.I18n.getText('stp.license.banner.expiresToday', productName,
                        '<a id=\'stp-licenseStatus-renewNow\' target=\'_blank\' href="' + renewLink + '">', '</a>',
                        '<a id=\'stp-licenseStatus-remindMeLater\' href=\'#\'>', '</a>',
                        '<a id=\'stp-licenseStatus-remindMeNever\' href=\'#\'>', '</a>');
                banner += "<span class ='aui-icon icon-warning'></span>\n</div>";
            } else {
                banner += AJS.I18n.getText('stp.license.banner.expiresSoon', productName, daysToExpiry,
                        '<a id=\'stp-licenseStatus-renewNow\' target=\'_blank\' href="' + renewLink + '">', '</a>',
                        '<a id=\'stp-licenseStatus-remindMeLater\' href=\'#\'>', '</a>',
                        '<a id=\'stp-licenseStatus-remindMeNever\' href=\'#\'>', '</a>');
                banner += "<span class ='aui-icon icon-warning'></span>\n</div>";
            }

            var $bannerContainer = $('#stp-licenseStatus-banner-container');
            if ($bannerContainer.length === 0) {
                $bannerContainer = $(document.body);
            }
            $bannerContainer.prepend(banner);

            AJS.$("#stp-licenseStatus-remindMeNever").click(LicenseStatus.remindMeNever);

            AJS.$("#stp-licenseStatus-remindMeLater").click(function (e) {
                e.preventDefault();
                LicenseStatus.remindMeLater();
            });

            AJS.$("#stp-licenseStatus-renewNow").click(function (e) {
                LicenseStatus.remindMeLater();
            });

            AJS.trigger('stp-licenseStatus-banner:created');
        }
    };

    AJS.$(document).ready(function () {
        var $daysToExpiryElement = AJS.$("meta[name='stp-license-days-to-expiry']");
        var $isAdminElement = AJS.$("meta[name='stp-license-is-admin']");
        var $shouldKeepBannerHiddenElement = AJS.$("meta[name='stp-license-should-keep-banner-hidden']");
        var $productNameElement = AJS.$("meta[name='stp-license-product-name']");

        var licenseData ={};

        var deferred = $.Deferred();

        var metaDataExists = $daysToExpiryElement.length && $isAdminElement.length &&
            $shouldKeepBannerHiddenElement.length && $productNameElement.length;

        if( metaDataExists ){
            var daysToExpiry = $daysToExpiryElement.attr("content") || -1;
            licenseData.daysToExpiry = parseInt(daysToExpiry);
            licenseData.shouldKeepBannerHidden = $shouldKeepBannerHiddenElement.attr("content") === "true";
            licenseData.isAdmin = $isAdminElement.attr("content") === "true";
            licenseData.productName = $productNameElement.attr("content");
            deferred.resolve(licenseData);
        } else {
            // fallback
            $.ajax(
                {
                    type: "GET",
                    dataType: "json",
                    async: true,
                    url: AJS.contextPath() + "/rest/stp/1.0/license/status",
                    headers: {
                        "X-Atlassian-Token": "no-check"
                    },
                    statusCode: {
                        200: function(data){
                            deferred.resolve($.extend(data,{
                                viaRest: true
                            }));
                        },
                        204: function(){
                            deferred.reject( '204. No reason to display banner.');
                        }
                    },
                    error: function(){
                        deferred.reject( 'Error returned from call to license/status');
                    }
                }
            )
        }

        deferred.done(function success(data){
            var withinExpiryRange = daysToExpiry < 30 && daysToExpiry >= 0;

            // If the data is retrieved from rest it means that the user is an admin, and the banner should
            // be displayed automatically. Otherwise, the rest resource would have returned an error response,
            // which is handled by rejecting the promise and passing the flow to the fail function below, instead
            if (data.viaRest || (data.isAdmin && withinExpiryRange && !data.shouldKeepBannerHidden)) {
                $('#stp-licenseStatus-banner').length || LicenseStatus.createBanner( data.daysToExpiry, data.productName );
            }
        }).fail(function fail(error){
            // Fail gracefully and don't show the banner.
            console.log('Not displaying license banner: ' + error);
        });


    });
})(AJS.$);
