/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.task;

import com.atlassian.support.tools.task.MonitoredCallable;
import com.atlassian.support.tools.task.MonitoredTaskExecutor;
import com.atlassian.support.tools.task.MutableTaskMonitor;
import com.atlassian.support.tools.task.TaskMonitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DefaultMonitoredTaskExecutor
implements MonitoredTaskExecutor {
    private static final long DEFAULT_CLEANUP_INTERVAL_NS = TimeUnit.MINUTES.toNanos(10L);
    private final ThreadPoolExecutor executorService;
    private final ConcurrentMap<String, ExpiringRef<MutableTaskMonitor<?>>> monitors;
    private long cleanupIntervalNanos;
    private long expiryIntervalNanos;
    private volatile long timestampNextCleanup = Long.MIN_VALUE;
    private volatile boolean shutdown;

    public DefaultMonitoredTaskExecutor(final String name, int maxThreads) {
        this.cleanupIntervalNanos = DEFAULT_CLEANUP_INTERVAL_NS;
        this.executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(name);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.executorService.allowCoreThreadTimeOut(true);
        this.monitors = new ConcurrentHashMap();
    }

    @Override
    public <M extends TaskMonitor> M getMonitor(@Nonnull String id) {
        this.maybeCleanup();
        ExpiringRef ref = (ExpiringRef)this.monitors.get(id);
        return (M)(ref == null ? null : (TaskMonitor)ref.value);
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.executorService.shutdown();
        }
    }

    @Override
    public <T, M extends MutableTaskMonitor<T>> M submit(@Nonnull MonitoredCallable<T, M> task) {
        this.maybeCleanup();
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"The executor has already been shut down");
        ListenableFutureTask futureTask = ListenableFutureTask.create(task);
        M monitor = task.getMonitor();
        this.initMonitor(monitor, (ListenableFutureTask<T>)futureTask);
        futureTask.addListener(new Runnable((MutableTaskMonitor)monitor){
            final /* synthetic */ MutableTaskMonitor val$monitor;
            {
                this.val$monitor = mutableTaskMonitor;
            }

            @Override
            public void run() {
                ExpiringRef ref = (ExpiringRef)DefaultMonitoredTaskExecutor.this.monitors.get(this.val$monitor.getTaskId());
                if (ref != null) {
                    ref.expireIn(DefaultMonitoredTaskExecutor.this.expiryIntervalNanos, TimeUnit.NANOSECONDS);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        this.executorService.submit((Runnable)futureTask);
        return monitor;
    }

    @VisibleForTesting
    void setExpiryInterval(long interval, TimeUnit timeUnit) {
        this.expiryIntervalNanos = timeUnit.toNanos(interval);
    }

    @VisibleForTesting
    void setCleanupInterval(long interval, TimeUnit timeUnit) {
        this.cleanupIntervalNanos = timeUnit.toNanos(interval);
    }

    protected <T, M extends MutableTaskMonitor<T>> void initMonitor(M monitor, ListenableFutureTask<T> future) {
        for (int i = 0; i < 100; ++i) {
            String id = UUID.randomUUID().toString();
            if (this.monitors.putIfAbsent(id, new ExpiringRef<M>(monitor)) != null) continue;
            monitor.init(id, future);
            return;
        }
        throw new IllegalStateException("Could not generate a unique task ID after 100 attempts");
    }

    protected void onExpired(MutableTaskMonitor<?> monitor) {
    }

    private void cleanup() {
        this.timestampNextCleanup = System.nanoTime() + this.cleanupIntervalNanos;
        Iterator it = this.monitors.values().iterator();
        while (it.hasNext()) {
            ExpiringRef ref = (ExpiringRef)it.next();
            if (!ref.isExpired()) continue;
            it.remove();
            this.onExpired((MutableTaskMonitor)ref.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCleanup() {
        if (System.nanoTime() > this.timestampNextCleanup) {
            ThreadPoolExecutor threadPoolExecutor = this.executorService;
            synchronized (threadPoolExecutor) {
                if (System.nanoTime() > this.timestampNextCleanup) {
                    this.cleanup();
                }
            }
        }
    }

    private static class ExpiringRef<V> {
        private final V value;
        private long expiryTimestamp;

        public ExpiringRef(V value) {
            this.value = value;
        }

        public void expireIn(long delay, TimeUnit unit) {
            this.expiryTimestamp = System.nanoTime() + unit.toNanos(delay);
        }

        public boolean isExpired() {
            return this.expiryTimestamp > 0L && System.nanoTime() > this.expiryTimestamp;
        }
    }
}

