/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.fisheye.spi.data.MailMessageData;
import com.atlassian.fisheye.spi.services.MailService;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SimpleSupportMailQueueItem;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import com.cenqua.fisheye.AppConfig;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FisheyeMailUtility
extends AbstractMailUtility {
    private static final Logger log = LoggerFactory.getLogger(FisheyeMailUtility.class);
    private final MailService mailService;

    public FisheyeMailUtility(MailService mailService) {
        this.mailService = mailService;
    }

    @Override
    public String getDefaultFromAddress() {
        return AppConfig.getsConfig().getConfig().getSmtp().getFrom();
    }

    @Override
    public boolean isMailServerConfigured() {
        return AppConfig.getsConfig().getConfig().getSmtp() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException {
        block7: {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(AppConfig.getsConfig().getClass().getClassLoader());
                if (!this.isMailServerConfigured()) {
                    Properties props = new Properties();
                    props.setProperty("mail.smtp.host", "mail.atlassian.com");
                    props.put("mail.smtp.starttls.enable", String.valueOf(true));
                    Session session = Session.getInstance((Properties)props);
                    MimeMessage msg = new MimeMessage(session);
                    msg.setFrom((Address)new InternetAddress(requestInfo.getFromAddress()));
                    msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)requestInfo.getToAddress(), (boolean)false));
                    msg.setSubject(requestInfo.getSubject());
                    for (Map.Entry<String, String> entry : requestInfo.getHeaders()) {
                        msg.addHeader(entry.getKey(), entry.getValue());
                    }
                    Multipart multiPart = SupportRequestMailQueueItem.toMultiPart(requestInfo);
                    msg.setContent(multiPart);
                    Transport.send((Message)msg);
                    log.info("Sent support request to {} using Atlassian mail server.", (Object)requestInfo.getToAddress());
                    break block7;
                }
                MailMessageData message = new MailMessageData();
                message.setFrom(requestInfo.getFromAddress());
                message.addRecipient(requestInfo.getToAddress());
                message.setSubject(requestInfo.getSubject());
                for (Map.Entry<String, String> entry : requestInfo.getHeaders()) {
                    message.addHeader(entry.getKey(), entry.getValue());
                }
                Multipart multiPart = SupportRequestMailQueueItem.toMultiPart(requestInfo);
                message.setMultiPartContent(multiPart);
                if (this.mailService.sendMessage(message)) {
                    log.info("Sent support request to {} successfully.", (Object)requestInfo.getToAddress());
                    break block7;
                }
                throw new MailException("Unable to send support request using configured mail server.");
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    @Override
    public void sendMail(Email email) {
        if (this.isMailServerConfigured()) {
            MailMessageData message = new MailMessageData();
            message.setFrom(email.getFrom());
            message.addRecipient(email.getTo());
            message.addRecipient(email.getCc());
            message.addRecipient(email.getBcc());
            message.setSubject(email.getSubject());
            message.setBodyText("text/html; charset=UTF-8", email.getBody());
            if (this.mailService.sendMessage(message)) {
                log.info("Sent scheduled email successfully.");
            } else {
                log.error("Unable to send scheduled mail using configured mail server.");
            }
        } else {
            SimpleSupportMailQueueItem item = new SimpleSupportMailQueueItem(email);
            try {
                item.send();
            }
            catch (MailException e) {
                log.error("Error sending mail using Atlassian mail server:", (Throwable)e);
            }
        }
    }
}

