/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.AbstractMailUtility;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdMailUtility
extends AbstractMailUtility {
    private static final Logger log = LoggerFactory.getLogger(AbstractMailUtility.class);
    private MailManager mailManager;

    CrowdMailUtility(MailManager mailManager) {
        this.mailManager = mailManager;
    }

    @Override
    public String getDefaultFromAddress() {
        return "noreply@atlassian.com";
    }

    @Override
    public boolean isMailServerConfigured() {
        return this.mailManager.isConfigured();
    }

    @Override
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        try {
            HashMap<String, Object> attachmentSources = new HashMap<String, Object>();
            for (SupportRequestAttachment attachment : requestInfo.getAttachments()) {
                Serializable data = attachment.getData();
                if (data instanceof byte[]) {
                    attachmentSources.put(attachment.getName(), new ByteArrayDataSource((byte[])data, attachment.getType()));
                    continue;
                }
                if (data instanceof String) {
                    attachmentSources.put(attachment.getName(), new ByteArrayDataSource(((String)((Object)data)).getBytes(), attachment.getType()));
                    continue;
                }
                if (data instanceof File) {
                    attachmentSources.put(attachment.getName(), new FileDataSource((File)data));
                    continue;
                }
                log.debug("Attachment [{}], of declared type [{}], contains unexpected data: '{}'. It will not be added to the mail message", (Object[])new String[]{attachment.getName(), attachment.getType(), data == null ? "(Null)" : data.getClass().getName()});
            }
            Iterable<Map.Entry<String, String>> headerEntries = requestInfo.getHeaders();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : headerEntries) {
                headerMap.put(entry.getKey(), entry.getValue());
            }
            this.mailManager.getClass().getMethod("sendPlainTextEmail", InternetAddress.class, String.class, String.class, Map.class, Map.class).invoke((Object)this.mailManager, new InternetAddress(requestInfo.getToAddress()), requestInfo.getSubject(), requestInfo.getBody(), headerMap, attachmentSources);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof MailSendException) {
                throw new MailException(e.getCause());
            }
            throw new RuntimeException(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendMail(Email email) {
        try {
            if (email.getMimeType().equals("text/html")) {
                this.mailManager.sendHtmlEmail(new InternetAddress(email.getTo()), email.getSubject(), email.getBody(), email.getBody());
            } else {
                this.mailManager.getClass().getMethod("sendPlainTextEmail", InternetAddress.class, String.class, String.class, Map.class, Map.class).invoke((Object)this.mailManager, new InternetAddress(email.getTo()), email.getSubject(), email.getBody(), email.getHeaders(), null);
            }
        }
        catch (MailSendException | ReflectiveOperationException | AddressException e) {
            throw new RuntimeException(e);
        }
    }
}

