/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSupportMailQueueItem
implements MailQueueItem,
Comparable<MailQueueItem> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSupportMailQueueItem.class);
    protected final Date dateQueued = new Date();
    protected volatile int sendCount = 0;
    protected boolean hasError = false;

    protected AbstractSupportMailQueueItem() {
    }

    public void execute() throws Exception {
        this.send();
    }

    public void send(Email email) throws MailException {
        ++this.sendCount;
        SMTPMailServerImpl smtpMailServer = new SMTPMailServerImpl(null, "AtlassianSMTP", "Atlassian SMTP Server", null, null, false, "mail.atlassian.com", null, null);
        try {
            SMTPMailServer configuredMailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (configuredMailServer != null) {
                smtpMailServer = configuredMailServer;
                log.warn("Sending message via mail server {}", (Object)smtpMailServer.getHostname());
            } else {
                log.warn("No mail server found, using Atlassian mail server.");
            }
        }
        catch (Exception e1) {
            log.error("Exception retrieving default mail server, using Atlassian mail server.", (Throwable)e1);
        }
        try {
            smtpMailServer.send(email);
            this.hasError = false;
            log.warn("Mail '{}' was successfully sent using the mail server '{}'.", (Object)email.getSubject(), (Object)smtpMailServer.getHostname());
        }
        catch (MailException e) {
            log.error("Error sending message '{}', see stack trace below for details.", (Object)email.getSubject());
            this.hasError = true;
            throw e;
        }
    }

    public Date getDateQueued() {
        return this.dateQueued;
    }

    public int getSendCount() {
        return this.sendCount;
    }

    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public int compareTo(MailQueueItem o) {
        return this.dateQueued.compareTo(o.getDateQueued());
    }
}

