/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.mail;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import com.atlassian.support.tools.salext.mail.SupportRequestMailQueueItem;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import java.io.IOException;
import java.io.Serializable;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailUtility
implements MailUtility {
    private static final Logger log = LoggerFactory.getLogger(AbstractMailUtility.class);
    private static final String PRIORITY_HEADER = "X-Support-Request-Priority";
    private static final String SUPPORT_REQUEST_PROPERTIES_SUFFIX = "-support-request.properties";
    private static final String REQUEST_HEADER_SUFFIX = "-Support-Request-Version";

    @Override
    public String getDefaultFromAddress() {
        try {
            return MailFactory.getServerManager().getDefaultSMTPMailServer().getDefaultFrom();
        }
        catch (MailException ex) {
            return "noreply@atlassian.com";
        }
    }

    @Override
    public void sendSupportRequestMail(SupportRequest supportRequest, SupportApplicationInfo info) throws MessagingException, MailException, IOException {
        String propertiesFileName = info.getApplicationName() + SUPPORT_REQUEST_PROPERTIES_SUFFIX;
        String requestVersionHeader = "X-" + info.getApplicationName() + REQUEST_HEADER_SUFFIX;
        String requestVersionNumber = "4.0";
        supportRequest.addHeader(PRIORITY_HEADER, String.valueOf(supportRequest.getPriority()));
        supportRequest.addHeader(requestVersionHeader, requestVersionNumber);
        supportRequest.addAttachment(this.makeAttachment(propertiesFileName, "text/xml", info.saveProperties(SupportInfoDetail.FULL)));
        supportRequest.addAttachment(this.makeAttachment("support-request-details.properties", "text/plain", supportRequest.saveForMail(info)));
        this.sendSupportRequestEmail(supportRequest, info);
    }

    SupportRequestAttachment makeAttachment(String propertiesFileName, String dataType, String propertyInfo) {
        return new SupportRequestAttachment(propertiesFileName, dataType, (Serializable)((Object)propertyInfo));
    }

    @Override
    public boolean isMailServerConfigured() {
        try {
            return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
        }
        catch (MailException mex) {
            log.warn("Could not successfully check for a default mail server.", (Throwable)mex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSupportRequestEmail(SupportRequest requestInfo, SupportApplicationInfo info) throws MailException, MessagingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (MailFactory.getServerManager() != null) {
                Thread.currentThread().setContextClassLoader(MailFactory.getServerManager().getClass().getClassLoader());
            }
            SupportRequestMailQueueItem item = new SupportRequestMailQueueItem(requestInfo, info);
            item.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

