/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle.fileset;

import com.atlassian.support.tools.salext.bundle.fileset.FileSet;
import com.atlassian.support.tools.salext.bundle.fileset.FileSetUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFileSet
implements FileSet {
    private static final Logger log = LoggerFactory.getLogger(RegexFileSet.class);
    private final File directory;
    private final RegexFileFilter fileFilter;
    private final boolean recursive;

    private RegexFileSet(File directory, Pattern filenamePattern, boolean recursive) {
        this.directory = directory;
        this.fileFilter = new RegexFileFilter(filenamePattern);
        this.recursive = recursive;
    }

    public static RegexFileSet fromDirectory(File directory, Pattern filenamePattern) {
        return new RegexFileSet(directory, filenamePattern, false);
    }

    public static RegexFileSet fromDirectoryPath(String directoryPath, Pattern filenamePattern) {
        return new RegexFileSet(FileSetUtil.fileWithPath(directoryPath), filenamePattern, false);
    }

    public static RegexFileSet fromDirectoryPathRecursive(String directoryPath, Pattern filenamePatter) {
        return new RegexFileSet(FileSetUtil.fileWithPath(directoryPath), filenamePatter, true);
    }

    public static RegexFileSet fromDirectoryRecursive(File directory, Pattern filenamePatter) {
        return new RegexFileSet(directory, filenamePatter, true);
    }

    @Override
    @Nonnull
    public Set<File> getFiles() {
        if (this.directory.isDirectory()) {
            IOFileFilter dirFilter = this.recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
            Collection files = FileUtils.listFiles((File)this.directory, (IOFileFilter)this.fileFilter, (IOFileFilter)dirFilter);
            for (File file : files) {
                if (file.length() != 0L) continue;
                log.debug("The file {} does not contain any data", (Object)file.getAbsolutePath());
            }
            return Collections.unmodifiableSet(new HashSet(files));
        }
        if (this.directory.isFile()) {
            log.warn("The requested base directory {} is a file rather than a directory, so the entire file set was skipped", (Object)this.directory.getAbsolutePath());
        } else {
            log.warn("The requested base directory {} does not exist, so the entire file set was skipped", (Object)this.directory.getAbsolutePath());
        }
        return Collections.emptySet();
    }
}

