/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.threaddump.LegacyThreadDumpGenerator;
import com.atlassian.support.tools.salext.bundle.threaddump.TDACompatibleThreadDumpGenerator;
import com.atlassian.support.tools.salext.bundle.threaddump.ThreadDumpGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = LoggerFactory.getLogger(ThreadDumpBundle.class);
    private static final DateFormat FILE_NAME_TS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssS");
    static final String PROPERTY_THREAD_DUMP_COUNT = "stp.threaddump.count";
    static final String PROPERTY_THREAD_DUMP_INTERVAL = "stp.threaddump.interval";
    static final int DEFAULT_THREAD_DUMP_COUNT = 3;
    static final int DEFAULT_THREAD_DUMP_INTERVAL = 5;
    private static final List<Class<? extends ThreadDumpGenerator>> THREAD_DUMP_GENERATORS = ImmutableList.of(TDACompatibleThreadDumpGenerator.class, LegacyThreadDumpGenerator.class);
    private final SupportApplicationInfo applicationInfo;
    private final int threadDumpCount;
    private final long threadDumpIntervalMillis;

    public ThreadDumpBundle(BundleManifest bundle, String title, String description, String baseDirectory, SupportApplicationInfo applicationInfo) {
        this(bundle, title, description, baseDirectory, applicationInfo, Integer.getInteger(PROPERTY_THREAD_DUMP_COUNT, 3), TimeUnit.SECONDS.toMillis(Integer.getInteger(PROPERTY_THREAD_DUMP_INTERVAL, 5).intValue()));
    }

    @VisibleForTesting
    protected ThreadDumpBundle(BundleManifest bundle, String title, String description, String baseDirectory, SupportApplicationInfo applicationInfo, int threadDumpCount, long threadDumpIntervalMillis) {
        super(bundle, title, description);
        this.applicationInfo = applicationInfo;
        this.threadDumpCount = threadDumpCount;
        this.threadDumpIntervalMillis = threadDumpIntervalMillis;
    }

    @Override
    public Map<String, String> getFiles() {
        try {
            return Collections.singletonMap(this.generateThreadDump().getAbsolutePath(), "");
        }
        catch (IOException e) {
            log.error("Failed to generate a thread dump.", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Failed to generate a thread dump.", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateThreadDump() throws IOException, InterruptedException {
        File logDirectory = new File(this.applicationInfo.getApplicationHome(), "logs/support");
        FileUtils.forceMkdir((File)logDirectory);
        int count = 0;
        String nameFormat = "threaddump_" + FILE_NAME_TS_FORMAT.format(new Date()) + "-%d.tdump";
        while (new File(logDirectory, String.format(nameFormat, count)).exists()) {
            ++count;
        }
        File threadDump = new File(logDirectory, String.format(nameFormat, count));
        if (!threadDump.createNewFile()) {
            throw new IOException("Failed to create file " + threadDump.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(threadDump);
        try {
            ThreadDumpGenerator generator = this.getFirstAvailableThreadDumpGenerator();
            if (generator != null) {
                for (int i = 1; i <= this.threadDumpCount; ++i) {
                    log.info("Generating thread dump {} of {}", (Object)i, (Object)this.threadDumpCount);
                    generator.generateThreadDump(out, this.applicationInfo);
                    if (i == this.threadDumpCount) continue;
                    log.info("Waiting {} seconds to take another thread dump", (Object)TimeUnit.MILLISECONDS.toSeconds(this.threadDumpIntervalMillis));
                    Thread.sleep(this.threadDumpIntervalMillis);
                }
            } else {
                log.error("Failed to generate thread dump: none of the generators can be initialized");
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return threadDump;
    }

    private ThreadDumpGenerator getFirstAvailableThreadDumpGenerator() {
        for (Class<? extends ThreadDumpGenerator> clazz : THREAD_DUMP_GENERATORS) {
            try {
                log.info("Attempting to instantiate strategy {}", (Object)clazz.getName());
                return clazz.newInstance();
            }
            catch (Throwable t) {
                log.info("Unable to instantiate strategy {}", (Object)clazz.getName(), (Object)t);
            }
        }
        return null;
    }
}

