/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext.bundle;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.AbstractApplicationFileBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationConfigurationFileBundle
extends AbstractApplicationFileBundle {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConfigurationFileBundle.class);
    private final Map<String, String> files;
    private final CrowdDirectoryService dirService;
    private final SupportApplicationInfo info;

    public AuthenticationConfigurationFileBundle(BundleManifest bundle, String title, String description, SupportApplicationInfo info, CrowdDirectoryService dirService, String ... files) {
        super(bundle, title, description);
        this.dirService = dirService;
        this.info = info;
        this.files = new HashMap<String, String>();
        for (String file : files) {
            this.files.put(file, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFiles() {
        File supportDir = new File(this.info.getApplicationHome(), "logs/support");
        if (!supportDir.exists() && !supportDir.mkdirs()) {
            log.error("Couldn't create export directory {}", (Object)supportDir.getAbsolutePath());
            return null;
        }
        File dirConfigFile = new File(supportDir, "directoryConfigurationSummary.txt");
        try {
            FileWriter configWriter = new FileWriter(dirConfigFile);
            try {
                configWriter.write(this.getDirectories());
            }
            catch (IOException e) {
                log.error("Failed to write directory configuration to {}.", (Object)dirConfigFile.getPath(), (Object)e);
            }
            finally {
                configWriter.flush();
                configWriter.close();
            }
            this.files.put(dirConfigFile.getAbsolutePath(), "");
        }
        catch (Exception e) {
            log.error("Can't generate directory configuration file.", (Throwable)e);
        }
        return this.files;
    }

    private String getDirectories() {
        StringBuilder configString = new StringBuilder();
        List dirs = this.dirService.findAllDirectories();
        if (dirs.isEmpty()) {
            configString.append("No directories, or something has gone wrong.");
        }
        for (Directory dir : dirs) {
            configString.append(dir.getName());
            configString.append("\n=============================\n");
            configString.append("Directory ID: ");
            configString.append(dir.getId());
            configString.append("\n");
            configString.append("Directory Type: ");
            configString.append(dir.getType());
            configString.append("\n");
            configString.append("Active: ");
            configString.append(dir.isActive());
            configString.append("\n");
            for (Map.Entry attribute : dir.getAttributes().entrySet()) {
                configString.append((String)attribute.getKey());
                configString.append(": ");
                configString.append((String)attribute.getValue());
                configString.append("\n");
            }
            configString.append("=============================\n");
            configString.append("\n\n");
        }
        return configString.toString();
    }
}

