/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.support.SupportInformationService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.support.tools.hercules.ScanItem;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.request.FileSanitizer;
import com.atlassian.support.tools.salext.AbstractSupportApplicationInfo;
import com.atlassian.support.tools.salext.ApplicationType;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.FileSetsBundle;
import com.atlassian.support.tools.salext.bundle.fileset.ExactFileSet;
import com.atlassian.support.tools.salext.bundle.fileset.RegexFileSet;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.ProductLicenseInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CrowdApplicationInfo
extends AbstractSupportApplicationInfo
implements InitializingBean,
DisposableBean {
    private static final String ROTATING_LOG_DESCRIPTION = "stp.hercules.scanitem.crowd.rot";
    private static final String ZIP_INCLUDE_CROWD_LOG_DESCRIPTION = "stp.zip.include.crowd.log.description";
    private static final String ZIP_INCLUDE_CROWD_LOG = "stp.zip.include.crowd.log";
    private static final String ZIP_INCLUDE_CROWD_CFG_DESCRIPTION = "stp.zip.include.crowd.cfg.description";
    private static final String ZIP_INCLUDE_CROWD_CFG = "stp.zip.include.crowd.cfg";
    private final SupportInformationService supportInformationService;
    private final TransactionTemplate transactionTemplate;
    private final LicenseHandler licenseHandler;
    private final BundleContext bundleContext;
    private ServiceTracker licenseServiceST;

    public CrowdApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, MailUtility mailUtility, SupportInformationService supportInformationService, TransactionTemplate transactionTemplate, LicenseHandler licenseHandler, BundleContext bundleContext) {
        super(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility);
        this.supportInformationService = supportInformationService;
        this.transactionTemplate = transactionTemplate;
        this.licenseHandler = licenseHandler;
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.licenseServiceST = new ServiceTracker(this.bundleContext, "com.atlassian.crowd.service.license.LicenseService", null);
        this.licenseServiceST.open();
    }

    @Override
    public SisyphusPatternSource getPatternSource() throws IOException, ClassNotFoundException, MalformedURLException {
        return this.getPatternSourceByURL("https://confluence.atlassian.com/download/attachments/179443532/crowd_regex_v2.xml", this.getProxy());
    }

    @Override
    public List<ScanItem> getApplicationLogFilePaths() {
        LinkedHashMap<String, String> paths = new LinkedHashMap<String, String>();
        paths.put(null, this.applicationProperties.getHomeDirectory().toString() + "/logs/atlassian-crowd.log");
        for (int i = 1; i <= 5; ++i) {
            paths.put(ROTATING_LOG_DESCRIPTION + i, this.applicationProperties.getHomeDirectory().toString() + "/logs/atlassian-crowd.log." + i);
        }
        LinkedList<ScanItem> result = new LinkedList<ScanItem>();
        for (Map.Entry entry : paths.entrySet()) {
            String description = (String)entry.getKey();
            String path = (String)entry.getValue();
            if (!new File(path).exists()) continue;
            result.add(description == null ? ScanItem.createDefaultItem(path) : new ScanItem(description, path));
        }
        return result;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        super.initServletInfo(config);
        String crowdHomePath = this.applicationProperties.getHomeDirectory().toString();
        String webInfClassesDir = this.getServletContextPath("WEB-INF/classes");
        String binDir = this.findTomcatFileOrDirectory("bin");
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_CONFIG, ZIP_INCLUDE_CROWD_CFG, ZIP_INCLUDE_CROWD_CFG_DESCRIPTION).fileSet(ExactFileSet.ofPaths(webInfClassesDir + "/log4j.properties", crowdHomePath + "/crowd.properties", crowdHomePath + "/crowd.cfg.xml", binDir + "/setenv.sh", binDir + "/setenv.bat", binDir + "/setclasspath.sh", binDir + "/setclasspath.bat", binDir + "/startup.sh", binDir + "/startup.bat", binDir + "/shutdown.sh", binDir + "/shutdown.bat")).build());
        String conf = this.findTomcatFileOrDirectory("conf");
        if (StringUtils.isNotBlank((String)conf)) {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_CONFIG, "stp.zip.include.tomcat.conf", "stp.zip.include.tomcat.conf.description").fileSet(RegexFileSet.fromDirectoryPath(conf, Pattern.compile("^.*.(xml|properties|policy)$"))).build());
        }
        this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.APPLICATION_LOGS, ZIP_INCLUDE_CROWD_LOG, ZIP_INCLUDE_CROWD_LOG_DESCRIPTION).fileSet(RegexFileSet.fromDirectoryPathRecursive(crowdHomePath, Pattern.compile("^.*atlassian-crowd\\.log(\\.[0-9])?$"))).build());
        String logs = this.findTomcatFileOrDirectory("logs");
        if (StringUtils.isNotBlank((String)logs)) {
            this.applicationInfoBundles.add(FileSetsBundle.builder(BundleManifest.TOMCAT_LOGS, "stp.zip.include.tomcat.logs", "stp.zip.include.tomcat.logs.description").fileSet(RegexFileSet.fromDirectoryPath(logs, Pattern.compile(".*gc.*\\.log.*|^.*\\.(log|out)$"))).build());
        }
    }

    @Override
    public String getCreateSupportRequestEmail() {
        return "crowd-autosupportrequests@atlassian.com";
    }

    @Override
    protected PropertyStore internalLoadProperties(SupportInfoDetail detail) {
        final PropertyStore store = super.internalLoadProperties(detail);
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                try {
                    Map supportInformation = (Map)CrowdApplicationInfo.this.supportInformationService.getClass().getMethod("getSupportInformationMap", User.class).invoke((Object)CrowdApplicationInfo.this.supportInformationService, new Object[]{null});
                    for (String key : supportInformation.keySet()) {
                        store.setValue("crowd." + key.replace("\\W", "_"), (String)supportInformation.get(key));
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        return store;
    }

    @Override
    public String getMailQueueURL(HttpServletRequest request) {
        return null;
    }

    @Override
    public boolean isMailExceptionAvailable() {
        return false;
    }

    @Override
    public String getMailServerConfigurationURL(HttpServletRequest request) {
        return this.getBaseURL(request) + "/console/secure/admin/mailserver.action";
    }

    @Override
    public FileSanitizer getFileSanitizer() {
        return new FileSanitizer(FILE_PATTERNS, EXECUTABLE_EXTENSIONS);
    }

    @Override
    public String getApplicationSEN() {
        return this.licenseHandler.getSupportEntitlementNumber();
    }

    @Override
    public String getApplicationServerID() {
        return this.licenseHandler.getServerId();
    }

    @Override
    public String getApplicationLogDir() {
        return this.getApplicationHome() + "/logs";
    }

    @Override
    public ApplicationLicenseInfo getLicenseInfo() {
        try {
            Object licenseService = this.licenseServiceST.getService();
            return new ProductLicenseInfo((ProductLicense)licenseService.getClass().getMethod("getLicense", null).invoke(licenseService, null));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAdminLicenseUrl() {
        return "/console/secure/admin/licensing.action";
    }

    @Override
    public ApplicationType getApplicationType() {
        return ApplicationType.CROWD;
    }

    @Override
    public Pattern getApplicationRestartPattern() {
        return Pattern.compile("(Starting\\sCrowd\\sServer)");
    }

    public void destroy() throws Exception {
        this.licenseServiceST.close();
    }

    static {
        FILE_PATTERNS.put("crowd.cfg.xml", Arrays.asList(Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.username\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"hibernate\\.connection\\.password\">)(.*)(?:</property>.*)"), Pattern.compile("(?:.*<property name=\"license\">)(.*)(?:</property>.*)")));
        FILE_PATTERNS.put("crowd.properties", Arrays.asList(Pattern.compile("^application\\.password=(.*)$")));
    }
}

