/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.salext;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sisyphus.RemoteXmlPatternSource;
import com.atlassian.sisyphus.SisyphusPatternSource;
import com.atlassian.support.tools.properties.MultiValuePropertyStore;
import com.atlassian.support.tools.properties.PropertyStore;
import com.atlassian.support.tools.properties.SupportInfoAppenderManager;
import com.atlassian.support.tools.properties.SupportInfoXmlKeyResolver;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.salext.bundle.ApplicationPropertiesInfoBundle;
import com.atlassian.support.tools.salext.bundle.BundleManifest;
import com.atlassian.support.tools.salext.bundle.ThreadDumpBundle;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.salext.output.XmlSupportInfoFormatter;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSupportApplicationInfo
implements SupportApplicationInfo {
    protected static final String DISABLED_PLUGINS = "stp.properties.plugins.disabled";
    protected static final String ENABLED_PLUGINS = "stp.properties.plugins.enabled";
    protected static final String HERCULES_REGEX_URL = "hercules.regex.url";
    protected static final String ZIP_INCLUDE_HEALTHCHECKS = "stp.zip.include.healthchecks";
    protected static final String ZIP_INCLUDE_HEALTHCHECKS_DESC = "stp.zip.include.healthchecks.description";
    private static final Logger log = LoggerFactory.getLogger(AbstractSupportApplicationInfo.class);
    protected final ApplicationProperties applicationProperties;
    protected final I18nResolver i18nResolver;
    protected final List<ApplicationInfoBundle> applicationInfoBundles = new ArrayList<ApplicationInfoBundle>();
    protected ServletContext servletContext;
    protected final UserManager userManager;
    protected final TemplateRenderer renderer;
    protected final SupportInfoAppenderManager supportInfoAppenderManager;
    protected final SupportInfoXmlKeyResolver supportInfoXmlKeyResolver;
    protected final PluginAccessor pluginAccessor;
    protected final MailUtility mailUtility;
    protected final ConcurrentOperationMap<Object, PropertyStore> propertyStoreOperationMap;
    public static final Map<String, List<Pattern>> FILE_PATTERNS = new HashMap<String, List<Pattern>>();
    private static final Pattern TOMCAT_USERS_SANITIZER_PATTERN = Pattern.compile("(?:.*(?:username|password|name)[ ]*=[ ]*[\"']?([^\"'> ]*)[\"']?.*)", 2);
    public static final List<String> EXECUTABLE_EXTENSIONS = Arrays.asList(".ade .adp .bat .chm .cmd .com .cpl .exe .hta .ins .isp .jar .jse .lib .lnk .mde .msc .msp .mst .pif .scr .sct .sh .shb .sys .vb .vbe .vbs .vxd .wsc .wsf .wsh".split(" "));

    public AbstractSupportApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, MailUtility mailUtility) {
        this(applicationProperties, i18nResolver, userManager, renderer, supportInfoAppenderManager, supportInfoXmlKeyResolver, pluginAccessor, mailUtility, (ConcurrentOperationMap<Object, PropertyStore>)new ConcurrentOperationMapImpl());
    }

    protected AbstractSupportApplicationInfo(ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager, TemplateRenderer renderer, SupportInfoAppenderManager supportInfoAppenderManager, SupportInfoXmlKeyResolver supportInfoXmlKeyResolver, PluginAccessor pluginAccessor, MailUtility mailUtility, ConcurrentOperationMap<Object, PropertyStore> propertyStoreOperationMap) {
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
        this.renderer = renderer;
        this.supportInfoAppenderManager = supportInfoAppenderManager;
        this.supportInfoXmlKeyResolver = supportInfoXmlKeyResolver;
        this.pluginAccessor = pluginAccessor;
        this.mailUtility = mailUtility;
        this.propertyStoreOperationMap = propertyStoreOperationMap;
        this.applicationInfoBundles.add(new ApplicationPropertiesInfoBundle(BundleManifest.APPLICATION_PROPERTIES, "stp.zip.include.application.properties", "stp.zip.include.application.properties.description", this));
        this.applicationInfoBundles.add(new ThreadDumpBundle(BundleManifest.THREAD_DUMP, "stp.zip.include.threadDump", "stp.zip.include.threadDump.description", null, this));
    }

    protected List<Plugin> getDisabledPlugins() {
        Collection disabledPlugins = this.pluginAccessor.getPlugins(new PluginPredicate(){

            public boolean matches(Plugin plugin) {
                return plugin != null && !AbstractSupportApplicationInfo.this.pluginAccessor.isPluginEnabled(plugin.getKey());
            }
        });
        if (disabledPlugins == null) {
            return Collections.emptyList();
        }
        ArrayList disabledPluginsList = new ArrayList(disabledPlugins);
        Collections.sort(disabledPluginsList, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin p1, Plugin p2) {
                return p1.getName().compareTo(p2.getName());
            }
        });
        return Collections.unmodifiableList(disabledPluginsList);
    }

    @Override
    public String getUserName() {
        return this.userManager.getRemoteUsername();
    }

    @Override
    public String getUserEmail() {
        try {
            UserProfile profile = this.userManager.getUserProfile(this.getUserName());
            return profile != null ? profile.getEmail() : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public final List<ApplicationInfoBundle> getApplicationFileBundles() {
        return this.applicationInfoBundles;
    }

    @Override
    public void initServletInfo(ServletConfig config) {
        this.servletContext = config.getServletContext();
    }

    @Override
    public final PropertyStore loadProperties(final SupportInfoDetail detail) {
        try {
            return (PropertyStore)this.propertyStoreOperationMap.runOperation((Object)detail, (Callable)new Callable<PropertyStore>(){

                @Override
                public PropertyStore call() throws Exception {
                    return AbstractSupportApplicationInfo.this.internalLoadProperties(detail);
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    protected PropertyStore internalLoadProperties(SupportInfoDetail detail) {
        MultiValuePropertyStore store = new MultiValuePropertyStore();
        this.supportInfoAppenderManager.addSupportInfo(store, detail);
        return store;
    }

    protected SisyphusPatternSource getPatternSourceByURL(String urlString, Proxy proxy) throws IOException, ClassNotFoundException {
        return new RemoteXmlPatternSource(new URL(urlString), proxy);
    }

    public String findTomcatFileOrDirectory(String fileOrDirectoryName) {
        String catalinaBase = System.getProperty("catalina.base");
        File file = new File(catalinaBase, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String catalinaHome = System.getProperty("catalina.home");
        file = new File(catalinaHome, fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String workingDirectory = System.getProperty("working.dir");
        file = new File(workingDirectory + "../", fileOrDirectoryName);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    @Override
    public String getApplicationName() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public String getApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    @Override
    public String getApplicationBuildNumber() {
        return this.applicationProperties.getBuildNumber();
    }

    @Override
    public Date getApplicationBuildDate() {
        return this.applicationProperties.getBuildDate();
    }

    @Override
    public String getApplicationHome() {
        return this.applicationProperties.getHomeDirectory().toString();
    }

    @Override
    public String getText(String key) {
        return this.i18nResolver.getText(key);
    }

    @Override
    public String getText(String key, Serializable ... arguments) {
        return this.i18nResolver.getText(key, arguments);
    }

    @Override
    public void flagSelectedApplicationFileBundles(HttpServletRequest req) {
        List<ApplicationInfoBundle> selectedApplicationFileBundles = this.getSelectedApplicationInfoBundles(req);
        for (ApplicationInfoBundle bundle : this.applicationInfoBundles) {
            if (selectedApplicationFileBundles != null && selectedApplicationFileBundles.size() >= 0 && req.getParameter("initialLoadDetector") != null) {
                if (selectedApplicationFileBundles.contains(bundle)) continue;
                bundle.setSelected(false);
                continue;
            }
            bundle.setSelected(true);
        }
    }

    @Override
    public List<ApplicationInfoBundle> getSelectedApplicationInfoBundles(HttpServletRequest req) {
        ArrayList<ApplicationInfoBundle> selectedApplicationInfoBundles = new ArrayList<ApplicationInfoBundle>();
        for (ApplicationInfoBundle applicationInfoBundle : this.applicationInfoBundles) {
            String flagValue = req.getParameter(applicationInfoBundle.getKey());
            if (flagValue == null || !Boolean.parseBoolean(flagValue)) continue;
            selectedApplicationInfoBundles.add(applicationInfoBundle);
        }
        return selectedApplicationInfoBundles;
    }

    @Override
    public String saveProperties(SupportInfoDetail detail) {
        PropertyStore supportInfoProperties = this.loadProperties(detail);
        Properties xmlElementNameMappings = this.supportInfoXmlKeyResolver.getKeyMappings();
        return XmlSupportInfoFormatter.getFormattedProperties(supportInfoProperties, xmlElementNameMappings, this.getStpVersion(), this.getApplicationName(), this.getApplicationVersion(), this.getApplicationSEN(), this.getApplicationServerID());
    }

    private String getStpVersion() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getVersion().toString();
        }
        return this.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.renderer;
    }

    @Override
    public String getBaseURL(HttpServletRequest req) {
        return req.getRequestURI().replaceFirst(req.getServletPath() + ".*", "");
    }

    @Override
    public List<String> getSystemWarnings() {
        return Collections.emptyList();
    }

    @Override
    public String getExportDirectory() {
        return this.getApplicationHome() + "/export";
    }

    @Override
    public String getFromAddress() {
        return this.mailUtility.getDefaultFromAddress();
    }

    protected Proxy getProxy() {
        String proxy = System.getProperty("http.proxyHost");
        if (StringUtils.isNotEmpty((String)proxy)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, (int)Integer.getInteger("http.proxyPort", 80)));
        }
        proxy = System.getProperty("https.proxyHost");
        if (StringUtils.isNotEmpty((String)proxy)) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, (int)Integer.getInteger("https.proxyPort", 443)));
        }
        return Proxy.NO_PROXY;
    }

    protected String getServletContextPath(String pathToLookup) {
        return this.servletContext.getRealPath(pathToLookup);
    }

    protected <T> T callAndLogExceptions(Callable<T> task) {
        try {
            return task.call();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        FILE_PATTERNS.put("server.xml", Arrays.asList(Pattern.compile("(?:.*(?:username|password|keystorePass|truststorePass|connectionPassword|connectionName)[ ]*=[ ]*[\"']?([^\"'> ]*)[\"']?.*)", 2)));
        FILE_PATTERNS.put("crowd.properties", Arrays.asList(Pattern.compile("application\\.password\\s+(.+)\\s*", 2)));
        FILE_PATTERNS.put("directoryConfigurationSummary.txt", Arrays.asList(Pattern.compile("(?:password.*:)\\s+(.+)", 2)));
        FILE_PATTERNS.put("tomcat-users.xml", Arrays.asList(TOMCAT_USERS_SANITIZER_PATTERN));
        FILE_PATTERNS.put("atlassian-user.xml", Arrays.asList(Pattern.compile("(?:securityPrincipal\\s*>)(.*)(?:</\\s*securityPrincipal)"), Pattern.compile("(?:securityCredential\\s*>)(.*)(?:</\\s*securityCredential)")));
    }
}

