/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.rest;

import com.atlassian.support.tools.rest.LicenseStatus;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.license.ApplicationLicenseInfo;
import com.atlassian.support.tools.salext.license.LicenseStatusService;
import com.atlassian.support.tools.security.PermissionValidationService;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="license")
public class LicenseStatusResource {
    private final PermissionValidationService permissionValidationService;
    private final SupportApplicationInfo appInfo;
    private final LicenseStatusService licenseStatusService;

    public LicenseStatusResource(PermissionValidationService permissionValidationService, SupportApplicationInfo appInfo, LicenseStatusService licenseStatusService) {
        this.appInfo = appInfo;
        this.permissionValidationService = permissionValidationService;
        this.licenseStatusService = licenseStatusService;
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public Response status() {
        this.permissionValidationService.validateIsAdmin();
        ApplicationLicenseInfo licenseInfo = this.appInfo.getLicenseInfo();
        if (licenseInfo.isEvaluation()) {
            return Response.status((int)204).build();
        }
        int daysToExpiry = licenseInfo.getDaysToExpiry();
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.licenseStatusService.resetBannerHiddenProperty();
            return Response.status((int)204).build();
        }
        if (this.licenseStatusService.shouldKeepBannerHidden(daysToExpiry)) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)new LicenseStatus(this.appInfo.getApplicationName(), this.appInfo.getApplicationSEN(), daysToExpiry)).build();
    }

    @POST
    @Path(value="remindMeLater")
    public Response remindMeLater() {
        this.permissionValidationService.validateIsAdmin();
        int daysToExpiry = this.appInfo.getLicenseInfo().getDaysToExpiry();
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.licenseStatusService.resetBannerHiddenProperty();
        } else {
            int hiddenTillDays = daysToExpiry / 2;
            hiddenTillDays = hiddenTillDays > 7 ? 15 : (hiddenTillDays > 0 ? 7 : 0);
            this.licenseStatusService.setHiddenUntilDays(hiddenTillDays);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="remindMeNever")
    public Response remindMeNever() {
        this.permissionValidationService.validateIsAdmin();
        int daysToExpiry = this.appInfo.getLicenseInfo().getDaysToExpiry();
        if (daysToExpiry > 30 || daysToExpiry < 0) {
            this.licenseStatusService.resetBannerHiddenProperty();
        } else {
            this.licenseStatusService.setHiddenUntilDays(-1);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="clearReminders")
    public Response clearReminders() {
        this.permissionValidationService.validateIsAdmin();
        this.licenseStatusService.resetBannerHiddenProperty();
        return Response.ok().build();
    }
}

