/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.support.tools.hercules.LogScanMonitor;
import com.atlassian.support.tools.hercules.LogScanService;
import com.atlassian.support.tools.rest.CacheControlUtils;
import com.atlassian.support.tools.rest.RestLogScanStatus;
import com.atlassian.support.tools.scheduler.ScheduledHerculesHealthReportAction;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="hercules")
@Produces(value={"application/json"})
@Singleton
public class HerculesResource {
    private final LogScanService scanService;
    private final ScheduledHerculesHealthReportAction action;

    public HerculesResource(LogScanService scanService, ScheduledHerculesHealthReportAction action) {
        this.scanService = scanService;
        this.action = action;
    }

    @GET
    @Path(value="scans/{id}")
    public Response getScanDetails(@PathParam(value="id") String id) {
        LogScanMonitor monitor = this.scanService.getMonitor(id);
        if (monitor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        if (monitor.isCancelled()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControlUtils.NO_CACHE).build();
        }
        Response.ResponseBuilder builder = Response.ok().entity((Object)new RestLogScanStatus(monitor));
        if (!monitor.isDone()) {
            builder.cacheControl(CacheControlUtils.NO_CACHE);
        }
        return builder.build();
    }

    @GET
    @Path(value="periodicScanner/settings")
    public Response getPeriodicScannerSettings() {
        Map<String, Object> map = this.action.getScannerSettings();
        Response.ResponseBuilder builder = Response.ok().entity(map);
        return builder.build();
    }

    @POST
    @Path(value="periodicScanner/settings")
    @XsrfProtectionExcluded
    public Response storePeriodicScannerSettings(@FormParam(value="atl_token") String token, @FormParam(value="enabled") String isEnabled, @FormParam(value="start-time-hour") int startHour, @FormParam(value="start-time-minute") int startMinute, @FormParam(value="frequency") String frequency, @FormParam(value="recipients") String recipients, @Context HttpServletRequest req) {
        Map<String, Object> map = this.action.storeScannerSettings(isEnabled, startHour, startMinute, frequency, recipients, token, req);
        Response.ResponseBuilder builder = map.containsKey("errors") || map.containsKey("tokenError") ? Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(map) : Response.ok().entity(map);
        return builder.build();
    }

    @ExperimentalApi
    @DELETE
    @Path(value="scans/removeCache")
    @XsrfProtectionExcluded
    public Response clearScanCache() {
        this.scanService.clearScanResultCache();
        return Response.status((Response.Status)Response.Status.OK).cacheControl(CacheControlUtils.NO_CACHE).build();
    }
}

