/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class SupportZipCreationRequest {
    private final List<ApplicationInfoBundle> bundles;
    private final boolean fileSizesLimited;

    protected SupportZipCreationRequest(AbstractBuilder builder) {
        this.bundles = builder.bundles.build();
        this.fileSizesLimited = builder.fileSizeLimited;
    }

    @Nonnull
    public List<ApplicationInfoBundle> getBundles() {
        return this.bundles;
    }

    public boolean isFileSizesLimited() {
        return this.fileSizesLimited;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder> {
        protected final ImmutableList.Builder<ApplicationInfoBundle> bundles = ImmutableList.builder();
        protected boolean fileSizeLimited;

        protected AbstractBuilder() {
        }

        @Nonnull
        public B bundles(@Nonnull ApplicationInfoBundle bundle, ApplicationInfoBundle ... moreBundles) {
            this.bundles.add(Preconditions.checkNotNull((Object)bundle, (Object)"bundle"));
            this.bundles.addAll((Iterator)Iterators.forArray((Object[])moreBundles));
            return this.self();
        }

        @Nonnull
        public B bundles(@Nonnull Iterable<ApplicationInfoBundle> values) {
            this.bundles.addAll((Iterable)Preconditions.checkNotNull(values, (Object)"values"));
            return this.self();
        }

        @Nonnull
        public B limitFileSizes(boolean value) {
            this.fileSizeLimited = value;
            return this.self();
        }

        @Nonnull
        public B limitFileSizes() {
            return this.limitFileSizes(true);
        }

        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Nonnull
        public SupportZipCreationRequest build() {
            return new SupportZipCreationRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

