/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.AbstractSupportToolsAction;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.events.StpSupportZipRanEvent;
import com.atlassian.support.tools.request.FileOptionsValidator;
import com.atlassian.support.tools.request.SupportRequestService;
import com.atlassian.support.tools.request.SupportZipCreationRequest;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import com.atlassian.support.tools.task.TaskMonitor;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportZipAction
extends AbstractSupportToolsAction {
    public static final String ACTION_NAME = "support-zip";
    private static final Logger log = LoggerFactory.getLogger(SupportZipAction.class);
    private final SupportApplicationInfo applicationInfo;
    private final SupportRequestService supportRequestService;
    private final EventPublisher eventPublisher;

    public SupportZipAction(SupportApplicationInfo applicationInfo, SupportRequestService supportRequestService, EventPublisher eventPublisher) {
        super(ACTION_NAME, "stp.contact.title", "stp.create.support.zip.title");
        this.applicationInfo = applicationInfo;
        this.supportRequestService = supportRequestService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public SupportToolsAction newInstance() {
        return new SupportZipAction(this.applicationInfo, this.supportRequestService, this.eventPublisher);
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest request, ValidationLog validationLog) {
        this.applicationInfo.flagSelectedApplicationFileBundles(request);
        context.put("maxBytesPerFile", "25Mb");
    }

    @Override
    public void validate(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        new FileOptionsValidator(this.applicationInfo).validate(context, req, validationLog);
        if (!validationLog.hasErrors()) {
            this.doAnalytics(req);
        }
    }

    private void doAnalytics(SafeHttpServletRequest req) {
        String supportZipOptions = "";
        for (Object key : req.getParameterMap().keySet()) {
            supportZipOptions = supportZipOptions + (String)key + ", ";
        }
        StpSupportZipRanEvent event = new StpSupportZipRanEvent(this, supportZipOptions);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public void execute(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        try {
            TaskMonitor<File> taskMonitor = this.supportRequestService.createZip(((SupportZipCreationRequest.Builder)((SupportZipCreationRequest.Builder)new SupportZipCreationRequest.Builder().bundles(this.applicationInfo.getSelectedApplicationInfoBundles(req))).limitFileSizes(req.getParameter("limit-file-sizes") != null)).build());
            context.put("taskId", taskMonitor.getTaskId());
        }
        catch (Exception e) {
            validationLog.addError("stp.create.support.zip.failed", new Serializable[]{this.applicationInfo.getApplicationLogDir(), e.getMessage()});
            log.error("Error creating support zip. Please zip up your {} directory and attach this file to the issue", (Object)this.applicationInfo.getApplicationLogDir(), (Object)e);
        }
    }
}

