/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.support.tools.request.SupportZipCreationRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;

public class SupportRequestCreationRequest
extends SupportZipCreationRequest {
    private final String description;
    private final String fromAddress;
    private final String subject;
    private final int priority;

    protected SupportRequestCreationRequest(Builder builder) {
        super(builder);
        this.description = (String)Preconditions.checkNotNull((Object)builder.description, (Object)"description");
        this.fromAddress = (String)Preconditions.checkNotNull((Object)builder.fromAddress, (Object)"fromAddress");
        this.subject = (String)Preconditions.checkNotNull((Object)builder.subject, (Object)"subject");
        this.priority = builder.priority;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getFromAddress() {
        return this.fromAddress;
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    public int getPriority() {
        return this.priority;
    }

    public static class Builder
    extends SupportZipCreationRequest.AbstractBuilder<Builder> {
        private String description;
        private String fromAddress;
        private String subject;
        private int priority;

        @Nonnull
        public SupportRequestCreationRequest build() {
            return new SupportRequestCreationRequest(this);
        }

        public Builder description(@Nonnull String value) {
            this.description = value;
            return this.self();
        }

        public Builder fromAddres(@Nonnull String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)value), (Object)"fromAddress is required");
            Preconditions.checkArgument((boolean)EmailValidator.getInstance().isValid(value), (Object)"fromAddress is invalid");
            this.fromAddress = value;
            return this.self();
        }

        public Builder subject(@Nonnull String value) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)value), (Object)"subject is required");
            this.subject = value;
            return this.self();
        }

        public Builder priority(int value) {
            this.priority = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

