/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.support.tools.request.CreateSupportRequestTask;
import com.atlassian.support.tools.request.CreateSupportZipTask;
import com.atlassian.support.tools.request.SupportRequestCreationRequest;
import com.atlassian.support.tools.request.SupportRequestService;
import com.atlassian.support.tools.request.SupportZipCreationRequest;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.security.PermissionValidationService;
import com.atlassian.support.tools.spi.HostApplication;
import com.atlassian.support.tools.task.MonitoredTaskExecutor;
import com.atlassian.support.tools.task.MonitoredTaskExecutorFactory;
import com.atlassian.support.tools.task.TaskMonitor;
import java.io.File;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultSupportRequestService
implements DisposableBean,
SupportRequestService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSupportRequestService.class);
    private final SupportApplicationInfo applicationInfo;
    private final MonitoredTaskExecutor executor;
    private final HostApplication hostApplication;
    private final MailUtility mailUtility;
    private final PermissionValidationService permissionValidationService;
    private final EventPublisher eventPublisher;

    public DefaultSupportRequestService(HostApplication hostApplication, SupportApplicationInfo applicationInfo, MailUtility mailUtility, PermissionValidationService permissionValidationService, MonitoredTaskExecutorFactory taskExecutorFactory, EventPublisher eventPublisher) {
        this.applicationInfo = applicationInfo;
        this.hostApplication = hostApplication;
        this.mailUtility = mailUtility;
        this.permissionValidationService = permissionValidationService;
        this.eventPublisher = eventPublisher;
        this.executor = taskExecutorFactory.create("support-request", 1);
    }

    @Override
    @Nonnull
    public TaskMonitor<Void> createSupportRequest(@Nonnull SupportRequestCreationRequest request) {
        this.permissionValidationService.validateIsAdmin();
        return this.executor.submit(new CreateSupportRequestTask(request, this.applicationInfo, this.hostApplication, this.mailUtility, this.eventPublisher));
    }

    @Override
    @Nonnull
    public TaskMonitor<File> createZip(@Nonnull SupportZipCreationRequest request) {
        this.permissionValidationService.validateIsAdmin();
        return this.executor.submit(new CreateSupportZipTask(request, this.applicationInfo, this.hostApplication));
    }

    public void destroy() {
        this.executor.shutdown();
    }

    @Override
    public <T> TaskMonitor<T> getMonitor(@Nonnull String id) {
        this.permissionValidationService.validateIsAdmin();
        return this.executor.getMonitor(id);
    }
}

