/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.request;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.MailException;
import com.atlassian.support.tools.action.DefaultMessage;
import com.atlassian.support.tools.events.StpSupportRequestEmailEvent;
import com.atlassian.support.tools.request.CreateSupportZipTask;
import com.atlassian.support.tools.request.SupportRequestCreationRequest;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.bundle.ApplicationInfoBundle;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.salext.mail.SupportRequest;
import com.atlassian.support.tools.salext.mail.SupportRequestAttachment;
import com.atlassian.support.tools.spi.HostApplication;
import com.atlassian.support.tools.task.DefaultTaskMonitor;
import com.atlassian.support.tools.task.MonitoredCallable;
import com.atlassian.support.tools.task.MutableTaskMonitor;
import com.atlassian.support.tools.task.SubtaskMonitorListener;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSupportRequestTask
implements MonitoredCallable<Void, MutableTaskMonitor<Void>> {
    private static final Logger log = LoggerFactory.getLogger(CreateSupportRequestTask.class);
    private static final int WEIGHT_CREATE_SUPPORT_ZIP = 90;
    private final SupportApplicationInfo applicationInfo;
    private final CreateSupportZipTask createZipTask;
    private final HostApplication hostApplication;
    private final MailUtility mailUtility;
    private final MutableTaskMonitor<Void> monitor;
    private final SupportRequestCreationRequest request;
    private final String username;
    private final EventPublisher eventPublisher;
    private final TemplateRenderer templateRenderer;

    public CreateSupportRequestTask(SupportRequestCreationRequest request, SupportApplicationInfo applicationInfo, HostApplication hostApplication, MailUtility mailUtility, EventPublisher eventPublisher) {
        this.applicationInfo = applicationInfo;
        this.hostApplication = hostApplication;
        this.mailUtility = mailUtility;
        this.request = request;
        this.templateRenderer = applicationInfo.getTemplateRenderer();
        this.username = applicationInfo.getUserName();
        this.eventPublisher = eventPublisher;
        this.monitor = new DefaultTaskMonitor<Void>();
        this.createZipTask = new CreateSupportZipTask(request, applicationInfo, hostApplication);
        ((DefaultTaskMonitor)this.createZipTask.getMonitor()).addListener(new SubtaskMonitorListener(this.monitor, 90));
    }

    @Override
    public Void call() throws Exception {
        return this.hostApplication.asUser(this.username, new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                CreateSupportRequestTask.this.createSupportRequest();
                return null;
            }
        }).call();
    }

    private void createSupportRequest() {
        try {
            File zipFile = this.createZipTask.call();
            this.monitor.updateProgress(90, this.applicationInfo.getText("stp.create.support.request.inprogress.message"));
            if (zipFile != null) {
                SupportRequest supportRequest = new SupportRequest();
                supportRequest.setDescription(this.request.getDescription());
                supportRequest.setFromAddress(this.request.getFromAddress());
                supportRequest.setSubject(this.request.getSubject());
                supportRequest.setPriority(this.request.getPriority());
                supportRequest.setToAddress(this.applicationInfo.getCreateSupportRequestEmail());
                supportRequest.setBody(this.generateMailBody());
                supportRequest.addAttachment(new SupportRequestAttachment(zipFile.getName(), "application/zip", zipFile));
                this.mailUtility.sendSupportRequestMail(supportRequest, this.applicationInfo);
            }
            this.monitor.updateProgress(100, this.applicationInfo.getText("stp.create.support.request.success.title"));
            this.doAnalytics(true);
        }
        catch (MailException e) {
            this.handleException((Exception)((Object)e), "Sending support request", "stp.mail.delivery.error");
        }
        catch (MessagingException e) {
            this.handleException((Exception)((Object)e), "Sending support request", "stp.mail.delivery.error");
        }
        catch (ConnectException e) {
            this.handleException(e, "Sending support request", "stp.mail.delivery.error");
        }
        catch (RenderingException e) {
            this.handleException((Exception)((Object)e), "Rendering support request", "stp.create.support.request.mail.rendering.error");
        }
        catch (IOException e) {
            this.handleException(e, "Sending support request", "stp.mail.delivery.error");
        }
        catch (Exception e) {
            this.handleException(e, "General error", "stp.mail.general.error");
        }
    }

    private void doAnalytics(boolean successful) {
        StringBuilder builder = new StringBuilder();
        for (ApplicationInfoBundle bundle : this.request.getBundles()) {
            builder.append(bundle.getKey()).append(",");
        }
        if (this.request.isFileSizesLimited()) {
            builder.append("limit-file-sizes");
        } else {
            builder.deleteCharAt(builder.length() - 1);
        }
        String supportZipOptions = builder.toString();
        this.eventPublisher.publish((Object)new StpSupportRequestEmailEvent(successful, supportZipOptions));
    }

    @Override
    @Nonnull
    public MutableTaskMonitor<Void> getMonitor() {
        return this.monitor;
    }

    private String generateMailBody() throws RenderingException, IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("description", this.request.getDescription());
        context.put("contactEmail", this.request.getFromAddress());
        context.put("priority", String.valueOf(this.request.getPriority()));
        StringWriter writer = new StringWriter();
        this.templateRenderer.render(this.getTemplateFile(), context, (Writer)writer);
        return writer.toString();
    }

    private void handleException(Exception e, String name, String key) {
        log.error(name, (Throwable)e);
        String errorMessage = this.applicationInfo.getText(key);
        this.monitor.updateProgress(100, errorMessage);
        this.monitor.addError(new DefaultMessage(name, errorMessage));
        this.doAnalytics(false);
    }

    private String getTemplateFile() {
        return "/templates/email/create-support-request.vm";
    }
}

