/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.properties.appenders;

import com.atlassian.support.tools.spi.RootLevelSupportInfoAppender;
import com.atlassian.support.tools.spi.SupportInfoBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class OperatingSystemSupportInfoAppender
extends RootLevelSupportInfoAppender {
    private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("###%");
    private final ExtendedOperatingSystemMXBean operatingSystemMXBean = (ExtendedOperatingSystemMXBean)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ExtendedOperatingSystemMXBean.class}, (InvocationHandler)new ExtendedOperatingSystemMXBeanProxy(ManagementFactory.getOperatingSystemMXBean()));

    @Override
    protected void addSupportInfo(SupportInfoBuilder builder) {
        builder = builder.addCategory("stp.properties.os");
        this.addString(builder, "name", this.operatingSystemMXBean.getName());
        this.addString(builder, "architecture", this.operatingSystemMXBean.getArch());
        this.addString(builder, "version", this.operatingSystemMXBean.getVersion());
        this.addNumber(builder, "available.processors", this.operatingSystemMXBean.getAvailableProcessors());
        this.addNumber(builder, "system.load.average", this.operatingSystemMXBean.getSystemLoadAverage());
        this.addNumber(builder, "committed.virtual.memory.size", this.operatingSystemMXBean.getCommittedVirtualMemorySize());
        this.addNumber(builder, "total.swap.space.size", this.operatingSystemMXBean.getTotalSwapSpaceSize());
        this.addNumber(builder, "free.swap.space.size", this.operatingSystemMXBean.getFreeSwapSpaceSize());
        this.addNumber(builder, "physical.memory.total", this.operatingSystemMXBean.getTotalPhysicalMemorySize());
        this.addNumber(builder, "physical.memory.free", this.operatingSystemMXBean.getFreePhysicalMemorySize());
        this.addPercentage(builder, "cpu.load.system", this.operatingSystemMXBean.getSystemCpuLoad());
        this.addPercentage(builder, "cpu.load.process", this.operatingSystemMXBean.getProcessCpuLoad());
        this.addNumber(builder, "file.descriptors.max", this.operatingSystemMXBean.getMaxFileDescriptorCount());
        this.addNumber(builder, "file.descriptors.open", this.operatingSystemMXBean.getOpenFileDescriptorCount());
    }

    private void addString(SupportInfoBuilder builder, String suffix, String value) {
        value = value == null ? "Unknown" : value;
        builder.addValue("stp.properties.os." + suffix, value);
    }

    private void addPercentage(SupportInfoBuilder builder, String suffix, double value) {
        String valueAsString = value < 0.0 ? null : PERCENTAGE_FORMAT.format(value);
        this.addString(builder, suffix, valueAsString);
    }

    private void addNumber(SupportInfoBuilder builder, String suffix, long value) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        String valueAsString = value < 0L ? null : nf.format(value);
        this.addString(builder, suffix, valueAsString);
    }

    private void addNumber(SupportInfoBuilder builder, String suffix, double value) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
        String valueAsString = value < 0.0 ? null : nf.format(value);
        this.addString(builder, suffix, valueAsString);
    }

    private static interface ExtendedOperatingSystemMXBean
    extends OperatingSystemMXBean {
        public long getCommittedVirtualMemorySize();

        public long getTotalSwapSpaceSize();

        public long getFreeSwapSpaceSize();

        public long getFreePhysicalMemorySize();

        public long getTotalPhysicalMemorySize();

        public double getSystemCpuLoad();

        public double getProcessCpuLoad();

        public long getMaxFileDescriptorCount();

        public long getOpenFileDescriptorCount();
    }

    private static class ExtendedOperatingSystemMXBeanProxy
    implements InvocationHandler {
        private final OperatingSystemMXBean delegate;

        private ExtendedOperatingSystemMXBeanProxy(OperatingSystemMXBean delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
            Method delegateMethod;
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            try {
                delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                delegateMethod = null;
            }
            if (delegateMethod == null) {
                return this.unknownValue(method.getReturnType());
            }
            delegateMethod.setAccessible(true);
            return delegateMethod.invoke((Object)this.delegate, params);
        }

        private Object unknownValue(Class<?> returnType) {
            if (Integer.TYPE.equals(returnType)) {
                return -1;
            }
            if (Long.TYPE.equals(returnType)) {
                return -1L;
            }
            if (Double.TYPE.equals(returnType)) {
                return -1.0;
            }
            return null;
        }
    }
}

