/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.hercules;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.AbstractSupportToolsAction;
import com.atlassian.support.tools.action.Message;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.events.EventStage;
import com.atlassian.support.tools.events.StpLogScannerEvent;
import com.atlassian.support.tools.hercules.HerculesDateTimeUtils;
import com.atlassian.support.tools.hercules.HerculesTools;
import com.atlassian.support.tools.hercules.LogScanMatch;
import com.atlassian.support.tools.hercules.LogScanMonitor;
import com.atlassian.support.tools.hercules.LogScanResult;
import com.atlassian.support.tools.hercules.LogScanService;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportToolsHerculesScanAction
extends AbstractSupportToolsAction {
    private static final Logger log = LoggerFactory.getLogger(SupportToolsHerculesScanAction.class);
    public static final String ACTION_NAME = "hercules";
    public static final String FIELD_LOG_FILE_PATH = "logFilePath";
    private final SupportApplicationInfo applicationInfo;
    private final LogScanService scanService;
    private final EventPublisher eventPublisher;

    public SupportToolsHerculesScanAction(SupportApplicationInfo info, LogScanService scanService, EventPublisher eventPublisher) {
        super(ACTION_NAME, "stp.troubleshooting.title", "stp.log.analyzer.title");
        this.applicationInfo = info;
        this.scanService = scanService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public SupportToolsAction newInstance() {
        return new SupportToolsHerculesScanAction(this.applicationInfo, this.scanService, this.eventPublisher);
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        if (req.getParameter("startAgain") != null) {
            LogScanMonitor monitor;
            String scanId = req.getParameter("scanId");
            if (scanId != null && (monitor = this.scanService.getMonitor(scanId)) != null && !monitor.isDone()) {
                monitor.cancel(true);
                this.scanService.clearScanResultCache();
            }
            if (context.containsKey("scanResults")) {
                context.remove("scanResults");
                context.remove("scanDate");
                context.remove(FIELD_LOG_FILE_PATH);
                context.remove("fileName");
            }
        } else {
            LogScanMonitor monitor = this.scanService.getLastScan();
            if (monitor != null && monitor.isDone()) {
                try {
                    context.put("cacheSupported", true);
                    context.put("herculesTools", new HerculesTools());
                    LogScanResult scanResults = (LogScanResult)monitor.get(100L, TimeUnit.MILLISECONDS);
                    if (!scanResults.isEmpty()) {
                        List<LogScanMatch> matches = scanResults.getMatches();
                        if (!matches.isEmpty()) {
                            context.put("scanResults", scanResults.getMatches());
                            File logFile = monitor.getLogFile();
                            String logFilePath = logFile.getPath();
                            String fileName = logFile.getName();
                            context.put("scanDate", HerculesDateTimeUtils.getTimeInRelativeFormat(monitor.getScanDate().getTime()));
                            context.put(FIELD_LOG_FILE_PATH, logFilePath);
                            context.put("fileName", fileName);
                        } else {
                            this.scanService.clearScanResultCache();
                        }
                    }
                }
                catch (TimeoutException e) {
                    log.debug("Log scan has not finished", (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn("Log scan failed", (Throwable)e);
                    validationLog.addError("stp.hercules.scan.failed", new Serializable[]{e.getCause().getMessage()});
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for log scan to complete", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void validate(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        String logFilePath = req.getParameter(FIELD_LOG_FILE_PATH);
        String scanId = req.getParameter("scanId");
        if (scanId != null) {
            LogScanMonitor monitor = this.scanService.getMonitor(scanId);
            if (monitor == null) {
                validationLog.addError("stp.hercules.scan.timedout", new Serializable[0]);
            }
        } else if (logFilePath == null || logFilePath.length() == 0) {
            validationLog.addFieldError(FIELD_LOG_FILE_PATH, "You must provide the location of a valid log file.");
        } else if (!new File(logFilePath).exists()) {
            validationLog.addFieldError(FIELD_LOG_FILE_PATH, "You must provide the location of a valid log file.");
        }
    }

    @Override
    public void execute(Map<String, Object> context, SafeHttpServletRequest req, ValidationLog validationLog) {
        String scanId = req.getParameter("scanId");
        String logFilePath = req.getParameter(FIELD_LOG_FILE_PATH);
        LogScanMonitor monitor = null;
        if (scanId != null && (monitor = this.scanService.getMonitor(scanId)) != null) {
            logFilePath = monitor.getLogFile().getPath();
        }
        if (monitor == null) {
            monitor = this.scanService.scan(new File(logFilePath));
            this.triggerAnalytics(EventStage.RAN, monitor);
            context.put("startTime", new DateTime().getMillis());
        }
        if (!context.containsKey("herculesTools")) {
            context.put("herculesTools", new HerculesTools());
        }
        context.put(FIELD_LOG_FILE_PATH, logFilePath);
        context.put("scanId", monitor.getTaskId());
        if (monitor.isDone()) {
            try {
                LogScanResult results = (LogScanResult)monitor.get(100L, TimeUnit.MILLISECONDS);
                List<LogScanMatch> matches = results.getMatches();
                if (monitor.getErrors().isEmpty()) {
                    context.put("scanResults", matches);
                } else {
                    for (Message message : monitor.getErrors()) {
                        validationLog.addError(message);
                        this.triggerAnalytics(EventStage.FAIL, monitor);
                    }
                }
                if (!monitor.getWarnings().isEmpty()) {
                    for (Message message : monitor.getWarnings()) {
                        validationLog.addWarning(message);
                        this.triggerAnalytics(EventStage.WARN, monitor);
                    }
                }
                String fileName = logFilePath.substring(logFilePath.lastIndexOf(File.separator) + 1);
                context.put("fileName", fileName);
                String startTime = req.getParameter("startTime");
                if (startTime != null && StringUtils.isNumeric((String)startTime)) {
                    long stopTime = new DateTime().getMillis();
                    long durationInSeconds = (stopTime - Long.parseLong(startTime)) / 1000L;
                    this.triggerAnalytics(EventStage.DONE, monitor, durationInSeconds, matches.size());
                }
            }
            catch (TimeoutException e) {
                log.debug("Log scan has not finished", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.warn("Log scan failed", (Throwable)e);
                validationLog.addError("stp.hercules.scan.failed", new Serializable[]{e.getCause().getMessage()});
                this.triggerAnalytics(EventStage.FAIL, monitor);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for log scan to complete", (Throwable)e);
            }
        }
    }

    private void triggerAnalytics(EventStage stage, LogScanMonitor monitor) {
        StpLogScannerEvent event = new StpLogScannerEvent(stage, monitor.getTaskId());
        this.eventPublisher.publish((Object)event);
    }

    private void triggerAnalytics(EventStage stage, LogScanMonitor monitor, long duration, int resultSize) {
        this.eventPublisher.publish((Object)new StpLogScannerEvent(stage, monitor.getTaskId(), duration, resultSize));
    }
}

