/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.hercules;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.support.tools.hercules.LogScanMonitor;
import com.atlassian.support.tools.hercules.LogScanReportRunner;
import com.atlassian.support.tools.hercules.LogScanReportSettings;
import com.atlassian.support.tools.hercules.LogScanReportTask;
import com.atlassian.support.tools.hercules.LogScanService;
import com.atlassian.support.tools.hercules.LogScanTask;
import com.atlassian.support.tools.hercules.cache.LogScanCacheSupplier;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.salext.mail.MailUtility;
import com.atlassian.support.tools.scheduler.ScheduleFactory;
import com.atlassian.support.tools.scheduler.SchedulerServiceProvider;
import com.atlassian.support.tools.scheduler.TaskSettingsStore;
import com.atlassian.support.tools.task.MonitoredTaskExecutor;
import com.atlassian.support.tools.task.MonitoredTaskExecutorFactory;
import com.atlassian.support.tools.task.TaskMonitor;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultLogScanService
implements LogScanService,
LifecycleAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogScanService.class);
    private static final String TASK_ID_HERCULES = "HerculesScheduledScanTask";
    private static final JobId JOB_ID = JobId.of("HerculesScheduledScanTask");
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of("HerculesScheduledScanTask");
    private static final String PROP_RECIPIENTS = "recipients";
    private final SupportApplicationInfo applicationInfo;
    private final LogScanCacheSupplier cacheSupplier;
    private final MonitoredTaskExecutor executor;
    private final MailUtility mailUtility;
    private final SchedulerServiceProvider schedulerServiceProvider;
    private final TaskSettingsStore taskSettingsStore;
    private SchedulerService schedulerService;

    public DefaultLogScanService(SupportApplicationInfo applicationInfo, MailUtility mailUtility, PluginSettingsFactory pluginSettingsFactory, SchedulerServiceProvider schedulerServiceProvider, LogScanCacheSupplier cacheSupplier, MonitoredTaskExecutorFactory taskExecutorFactory, ScheduleFactory scheduleFactory) {
        this.applicationInfo = applicationInfo;
        this.cacheSupplier = cacheSupplier;
        this.mailUtility = mailUtility;
        this.schedulerServiceProvider = schedulerServiceProvider;
        this.executor = taskExecutorFactory.create("hercules", 1);
        this.taskSettingsStore = new TaskSettingsStore(TASK_ID_HERCULES, pluginSettingsFactory.createGlobalSettings(), scheduleFactory);
    }

    public void destroy() {
        this.executor.shutdown();
        this.schedulerService.unregisterJobRunner(JobRunnerKey.of(TASK_ID_HERCULES));
        this.clearScanResultCache();
    }

    @Override
    public LogScanMonitor getMonitor(@Nonnull String taskId) {
        return (LogScanMonitor)this.executor.getMonitor(taskId);
    }

    @Override
    @Nonnull
    public LogScanReportSettings getReportSettings() {
        return new LogScanReportSettings.Builder().enabled(this.taskSettingsStore.isEnabled()).recipients(this.taskSettingsStore.getStringProperty(PROP_RECIPIENTS)).schedule(this.taskSettingsStore.getSchedule()).build();
    }

    public void onStart() {
        this.schedulerService = this.schedulerServiceProvider.getSchedulerService();
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, new LogScanReportRunner(this));
        LogScanReportSettings settings = this.getReportSettings();
        if (settings.isEnabled()) {
            this.scheduleLogScanJob(settings.getSchedule());
        }
    }

    @Override
    @Nonnull
    public LogScanMonitor scan(@Nonnull File logFile) {
        LogScanMonitor monitor = this.executor.submit(new LogScanTask(logFile, this.applicationInfo));
        this.cacheSupplier.getCache().set(monitor);
        return monitor;
    }

    @Override
    @Nonnull
    public TaskMonitor<Void> sendLogScanReport() {
        return this.executor.submit(new LogScanReportTask(this.applicationInfo, this.mailUtility, this.getReportSettings()));
    }

    @Override
    public void setReportSettings(@Nonnull LogScanReportSettings settings) {
        Schedule schedule = settings.getSchedule();
        this.taskSettingsStore.setEnabled(settings.isEnabled());
        this.taskSettingsStore.setProperty(PROP_RECIPIENTS, settings.getRecipients());
        this.taskSettingsStore.setSchedule(schedule);
        if (settings.isEnabled()) {
            this.scheduleLogScanJob(settings.getSchedule());
        } else {
            this.schedulerService.unscheduleJob(JOB_ID);
        }
    }

    @Override
    @Nullable
    public LogScanMonitor getLastScan() {
        return this.cacheSupplier.getCache().get();
    }

    @Override
    public void clearScanResultCache() {
        this.cacheSupplier.getCache().destroy();
    }

    private void scheduleLogScanJob(Schedule schedule) {
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey(JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule log scan job", (Throwable)e);
        }
    }
}

