/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.tools.action.impl;

import com.atlassian.support.tools.ValidationLog;
import com.atlassian.support.tools.action.AbstractSupportToolsAction;
import com.atlassian.support.tools.action.SupportToolsAction;
import com.atlassian.support.tools.salext.SupportApplicationInfo;
import com.atlassian.support.tools.servlet.SafeHttpServletRequest;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.atlassian.support.tools.spi.Version;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class DetectIssuesAction
extends AbstractSupportToolsAction {
    public static final String ACTION_NAME = "detect-issues";
    private static final Map<String, Version> SUPPORTED_APPS_AND_VERSIONS = ImmutableMap.builder().put((Object)"Confluence", (Object)new Version(5, 5, 0)).put((Object)"JIRA", (Object)new Version(6, 3, 3)).put((Object)"Bamboo", (Object)new Version(5, 11, 0)).build();
    private final SupportApplicationInfo info;

    public DetectIssuesAction(SupportApplicationInfo info) {
        super(ACTION_NAME, "stp.instance.health.title", "stp.instance.health.title", "templates/html/detect-issues.vm");
        this.info = info;
    }

    public static boolean isAvailable(String appName, Version appVersion) {
        Version minimumVersion = SUPPORTED_APPS_AND_VERSIONS.get(appName);
        return minimumVersion != null && appVersion.compareTo(minimumVersion) >= 0;
    }

    @Override
    public SupportToolsAction newInstance() {
        return new DetectIssuesAction(this.info);
    }

    @Override
    public void prepare(Map<String, Object> context, SafeHttpServletRequest request, ValidationLog validationLog) {
        context.put("info", this.info);
        context.put("props", this.info.loadProperties(SupportInfoDetail.BASIC));
    }
}

