/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sisyphus;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SisyphusPattern {
    private static final Logger log = Logger.getLogger(SisyphusPattern.class);
    private String pageName;
    private String regex;
    private String URL;
    private String Id;
    private String sourceID;
    private String priority;
    private String status;
    private String resolution;
    private String fixVersion;
    private transient Pattern pattern = null;
    private transient boolean isBrokenPattern = false;
    private transient ThreadLocal<Matcher> matcher;
    private static final String FIVE_K_CHAR_LINE = "An error occurred whilst rendering this message. Please contact the administrators, and inform them of this bug. Details: ------- org.apache.velocity.exception.MethodInvocationException: Invocation of method 'getNotEmptySectionsForLocation' in class com.atlassian.jira.plugin.webfragment.DefaultSimpleLinkManager threw exception class java.lang.IllegalStateException : Method invoked on module descriptor after it was destroyed. This is only legal for some methods on AbstractModuleDescriptor. at org.apache.velocity.runtime.parser.node.ASTMethod.execute(ASTMethod.java:251) at org.apache.velocity.runtime.parser.node.ASTReference.execute(ASTReference.java:175) at org.apache.velocity.runtime.parser.node.ASTReference.value(ASTReference.java:327) at org.apache.velocity.runtime.parser.node.ASTExpression.value(ASTExpression.java:51) at org.apache.velocity.runtime.parser.node.ASTSetDirective.render(ASTSetDirective.java:95) at org.apache.velocity.runtime.parser.node.SimpleNode.render(SimpleNode.java:230) at org.apache.velocity.Template.merge(Template.java:256) at org.apache.velocity.app.VelocityEngine.mergeTemplate(VelocityEngine.java:422) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:77) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:61) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:56) at com.atlassian.jira.web.component.AbstractWebComponent.getHtml(AbstractWebComponent.java:33) at com.atlassian.jira.web.component.webfragment.WebFragmentWebComponent.getHtml(WebFragmentWebComponent.java:48) at sun.reflect.GeneratedMethodAccessor1039.invoke(Unknown Source) at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:25) at java.lang.reflect.Method.invoke(Method.java:597) at org.apache.velocity.util.introspection.UberspectImpl$VelMethodImpl.invoke(UberspectImpl.java:234) at org.apache.velocity.runtime.parser.node.ASTMethod.execute(ASTMethod.java:203) at org.apache.velocity.runtime.parser.node.ASTReference.execute(ASTReference.java:175) at org.apache.velocity.runtime.parser.node.ASTReference.render(ASTReference.java:220) at org.apache.velocity.runtime.parser.node.ASTBlock.render(ASTBlock.java:55) at org.apache.velocity.runtime.parser.node.ASTIfStatement.render(ASTIfStatement.java:70) at org.apache.velocity.runtime.parser.node.SimpleNode.render(SimpleNode.java:230) at org.apache.velocity.Template.merge(Template.java:256) at org.apache.velocity.app.VelocityEngine.mergeTemplate(VelocityEngine.java:422) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:77) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:61) at com.atlassian.velocity.DefaultVelocityManager.getEncodedBody(DefaultVelocityManager.java:56) at com.atlassian.jira.plugin.AbstractJiraModuleDescriptor.getHtml(AbstractJiraModuleDescriptor.java:109) at com.atlassian.jira.plugin.navigation.TopNavigationModuleDescriptorImpl.getTopNavigationHtml(TopNavigationModuleDescriptorImpl.java:84) at com.atlassian.jira.plugin.navigation.DefaultPluggableTopNavigation.getHtml(DefaultPluggableTopNavigation.java:23) at org.apache.jsp.decorators.admin_jsp._jspService(admin_jsp.java:551) at org.apache.jasper.runtime.HttpJspBase.service(HttpJspBase.java:70) at javax.servlet.http.HttpServlet.service(HttpServlet.java:717) at org.apache.jasper.servlet.JspServletWrapper.service(JspServletWrapper.java:386) at org.apache.jasper.servlet.JspServlet.serviceJspFile(JspServlet.java:313) at org.apache.jasper.servlet.JspServlet.service(JspServlet.java:260) at javax.servlet.http.HttpServlet.service(HttpServlet.java:717) at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:290) at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:206) at com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46) at com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:77) at com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:63) at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:235) at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:206) at com.atlassian.plugin.servlet.filter.IteratingFilterChain.doFilter(IteratingFilterChain.java:46) at com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:77) at com.atlassian.plugin.servlet.filter.ServletFilterModuleContainerFilter.doFilter(ServletFilterModuleContainerFilter.java:63) at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:235) at org.apache.catalina.core.ApplicationFilterChain.doFilter(Application";

    public SisyphusPattern() {
    }

    public SisyphusPattern(String id) {
        this.Id = id;
    }

    public SisyphusPattern(SisyphusPattern other) {
        this.setId(other.getId());
        this.setPageName(other.getPageName());
        this.setURL(other.getURL());
        this.setRegex(other.getRegex());
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getURL() {
        return this.URL;
    }

    public String getId() {
        return this.Id;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getFixVersion() {
        return this.fixVersion;
    }

    public void setPageName(String pn) {
        this.pageName = pn;
    }

    public void setRegex(String r) {
        this.regex = r;
        this.compile();
    }

    private void compile() {
        if (StringUtils.isEmpty((String)this.regex)) {
            this.isBrokenPattern = true;
            return;
        }
        try {
            this.pattern = Pattern.compile(this.regex);
            if (this.matcher == null) {
                this.matcher = new ThreadLocal();
            }
            this.matcher.set(this.pattern.matcher(""));
            this.isBrokenPattern = this.regex.equals("") || this.regex.equals("$body");
        }
        catch (PatternSyntaxException e) {
            this.isBrokenPattern = true;
            log.error((Object)("Failed to compile pattern '" + this.getPageName() + "' at " + this.getURL()), (Throwable)e);
        }
    }

    public Pattern getPattern() {
        if (this.isBrokenPattern) {
            return null;
        }
        if (this.pattern == null) {
            this.compile();
        }
        return this.pattern;
    }

    public Matcher getMatcher() {
        if (this.matcher != null && this.matcher.get() != null) {
            return this.matcher.get();
        }
        this.compile();
        return this.matcher.get();
    }

    public boolean isBrokenPattern() {
        return this.isBrokenPattern;
    }

    public void setURL(String u) {
        this.URL = u;
    }

    public void setId(String id) {
        this.Id = id;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public void setFixVersion(String fixVersion) {
        this.fixVersion = fixVersion;
    }

    public void setSourceID(String sourceID) {
        this.sourceID = sourceID;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public boolean equals(Object obj) {
        SisyphusPattern other = (SisyphusPattern)obj;
        if (!other.Id.equals(this.Id)) {
            return false;
        }
        if (!other.pageName.equals(this.pageName)) {
            return false;
        }
        if (!other.URL.equals(this.URL)) {
            return false;
        }
        return other.regex.equals(this.regex);
    }

    public long testPattern() {
        Pattern pat = this.getPattern();
        if (pat != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current Pattern being tested for efficiency: " + this.toString()));
            }
            long matchtime = System.currentTimeMillis();
            Matcher matcher = pat.matcher(FIVE_K_CHAR_LINE);
            matcher.find();
            return System.currentTimeMillis() - matchtime;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Regexp would not compile and was skipped: " + this.getRegex()));
        }
        return -1L;
    }
}

