/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.jira;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.role.RoleCreatedEvent;
import com.atlassian.crowd.event.role.RoleDeletedEvent;
import com.atlassian.crowd.event.role.RoleUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.permission.AbstractGlobalPermissionEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.pocketknife.api.lifecycle.modules.ModuleRegistrationHandle;
import com.atlassian.upm.license.role.jira.DynamicGlobalPermissionService;
import com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache;
import com.atlassian.upm.license.role.jira.JiraLicensingRole;
import com.atlassian.upm.license.role.spi.LicensingRole;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;
import com.atlassian.upm.license.role.spi.LicensingRoleMembershipUpdatedEvent;
import com.atlassian.upm.license.role.spi.RoleBasedLicenseService;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JiraRoleBasedLicenseService
implements RoleBasedLicenseService,
InitializingBean,
DisposableBean {
    private final GlobalPermissionManager permissionManager;
    private final UserManager userManager;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionUserCountCache globalPermissionUserCountCache;
    private final DynamicGlobalPermissionService dynamicGlobalPermissionService;
    private final ConcurrentMap<String, ConcurrentMap<String, String>> pluginKeysPerPermission;
    private final ConcurrentMap<String, ModuleRegistrationHandle> permissionModulesPerPluginKey;
    private static final Iterable<Class<? extends DirectoryEvent>> eventWhitelist = ImmutableList.of(DirectoryCreatedEvent.class, DirectoryDeletedEvent.class, DirectoryUpdatedEvent.class, GroupCreatedEvent.class, GroupDeletedEvent.class, RoleCreatedEvent.class, RoleDeletedEvent.class, RoleUpdatedEvent.class, UserCreatedEvent.class, UserDeletedEvent.class, UserRenamedEvent.class);

    public JiraRoleBasedLicenseService(GlobalPermissionManager permissionManager, UserManager userManager, EventPublisher eventPublisher, DynamicGlobalPermissionService dynamicGlobalPermissionService, GlobalPermissionUserCountCache globalPermissionUserCountCache) {
        this.permissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.dynamicGlobalPermissionService = (DynamicGlobalPermissionService)Preconditions.checkNotNull((Object)dynamicGlobalPermissionService, (Object)"dynamicGlobalPermissionService");
        this.globalPermissionUserCountCache = (GlobalPermissionUserCountCache)Preconditions.checkNotNull((Object)globalPermissionUserCountCache, (Object)"globalPermissionUserCountCache");
        this.pluginKeysPerPermission = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
        this.permissionModulesPerPluginKey = new ConcurrentHashMap<String, ModuleRegistrationHandle>();
    }

    public LicensingRole createLicensingRole(Plugin plugin, String key, String nameI18nKey, String descriptionI18nKey) throws LicensingRoleCreationFailedException {
        Iterator iterator = Option.option((Object)this.getLicensingRole(plugin, key)).iterator();
        if (iterator.hasNext()) {
            LicensingRole role = (LicensingRole)iterator.next();
            return role;
        }
        ModuleRegistrationHandle moduleHandle = this.dynamicGlobalPermissionService.dynamicallyCreatePermission(plugin, key, nameI18nKey, descriptionI18nKey);
        this.permissionModulesPerPluginKey.put(plugin.getKey(), moduleHandle);
        return this.getLicensingRole(plugin, key);
    }

    public LicensingRole getLicensingRole(Plugin plugin, String key) {
        Iterator iterator = this.permissionManager.getGlobalPermission(key).iterator();
        if (iterator.hasNext()) {
            GlobalPermissionType type = (GlobalPermissionType)iterator.next();
            String pluginKey = plugin.getKey();
            String typeKey = type.getKey();
            this.pluginKeysPerPermission.putIfAbsent(typeKey, new ConcurrentHashMap());
            ((ConcurrentMap)this.pluginKeysPerPermission.get(typeKey)).putIfAbsent(pluginKey, pluginKey);
            return new JiraLicensingRole(this.permissionManager, this.userManager, type, this.globalPermissionUserCountCache);
        }
        return null;
    }

    public void onPluginUnlicensedEvent(Plugin plugin) {
        for (ModuleRegistrationHandle handle : Option.option(this.permissionModulesPerPluginKey.get(plugin.getKey()))) {
            handle.unregister();
            this.permissionModulesPerPluginKey.remove(plugin.getKey());
        }
    }

    @EventListener
    public void onGlobalPermissionEvent(AbstractGlobalPermissionEvent event) {
        this.handleEventForGlobalPermission(event.getGlobalPermissionType().getGlobalPermissionKey());
    }

    @EventListener
    public void onCrowdDirectoryEvent(DirectoryEvent event) {
        if (event instanceof GroupMembershipCreatedEvent) {
            this.handleEventForGroupName(((GroupMembershipCreatedEvent)event).getGroupName());
        } else if (event instanceof GroupMembershipDeletedEvent) {
            this.handleEventForGroupName(((GroupMembershipDeletedEvent)event).getGroupName());
        } else if (this.inWhitelist(event.getClass())) {
            this.handleEventForUnidentifiedGlobalPermission();
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        this.handleEventForGroupName(event.getGroupName());
    }

    @EventListener
    public void onDirectorySynchronisation(RemoteDirectorySynchronisedEvent event) {
        this.handleEventForUnidentifiedGlobalPermission();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.handleEventForUnidentifiedGlobalPermission();
    }

    private void handleEventForGroupName(String groupName) {
        for (GlobalPermissionKey permission : this.getPermissionsWithGroup(groupName)) {
            if (GlobalPermissionKey.USE.equals((Object)permission)) {
                this.handleEventForUnidentifiedGlobalPermission();
                continue;
            }
            this.handleEventForGlobalPermission(permission);
        }
    }

    private void handleEventForGlobalPermission(GlobalPermissionKey permission) {
        this.globalPermissionUserCountCache.reset(permission);
        for (String pluginKey : this.getPluginKeysWithPermission(permission)) {
            this.eventPublisher.publish((Object)new LicensingRoleMembershipUpdatedEvent(pluginKey));
        }
    }

    private void handleEventForUnidentifiedGlobalPermission() {
        this.globalPermissionUserCountCache.resetAll();
        this.eventPublisher.publish((Object)new LicensingRoleMembershipUpdatedEvent("*"));
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private Iterable<String> getPluginKeysWithPermission(GlobalPermissionKey permissionKey) {
        Map keysMap = (Map)this.pluginKeysPerPermission.get(permissionKey.getKey());
        return keysMap == null ? ImmutableList.of() : ImmutableList.copyOf(keysMap.values());
    }

    private Iterable<GlobalPermissionKey> getPermissionsWithGroup(String groupName) {
        ImmutableList.Builder withGroup = ImmutableList.builder();
        for (GlobalPermissionType permission : this.permissionManager.getAllGlobalPermissions()) {
            if (!this.permissionManager.getGroupNamesWithPermission(permission.getGlobalPermissionKey()).contains(groupName)) continue;
            withGroup.add((Object)permission.getGlobalPermissionKey());
        }
        return withGroup.build();
    }

    private boolean inWhitelist(final Class<? extends DirectoryEvent> clazz) {
        return Iterables.any(eventWhitelist, (Predicate)new Predicate<Class<? extends DirectoryEvent>>(){

            public boolean apply(Class<? extends DirectoryEvent> c) {
                return c.isAssignableFrom(clazz);
            }
        });
    }
}

