/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.jira;

import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache;
import com.atlassian.upm.license.role.spi.AbstractLicensingRole;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Iterator;

public class JiraLicensingRole
extends AbstractLicensingRole {
    private final GlobalPermissionManager permissionManager;
    private final UserManager userManager;
    private final GlobalPermissionKey permission;
    private final GlobalPermissionUserCountCache globalPermissionUserCountCache;

    public JiraLicensingRole(GlobalPermissionManager permissionManager, UserManager userManager, GlobalPermissionType permission, GlobalPermissionUserCountCache globalPermissionUserCountCache) {
        super(permission.getKey(), permission.getNameI18nKey(), permission.getDescriptionI18nKey());
        this.permissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)permissionManager, (Object)"permissionManager");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.permission = (GlobalPermissionKey)Preconditions.checkNotNull((Object)permission.getGlobalPermissionKey(), (Object)"permission");
        this.globalPermissionUserCountCache = (GlobalPermissionUserCountCache)Preconditions.checkNotNull((Object)globalPermissionUserCountCache, (Object)"globalPermissionUserCountCache");
    }

    public URI getManagementPage() {
        if ("com.atlassian.servicedesk.agent.access".equals(this.getKey())) {
            return URI.create("/secure/admin/AgentAllocation.jspa");
        }
        return URI.create("/secure/admin/GlobalPermissions!default.jspa");
    }

    public boolean isUserInRole(String userKey) {
        Iterator iterator = Option.option((Object)this.userManager.getUserByKey(userKey)).iterator();
        if (iterator.hasNext()) {
            ApplicationUser user = (ApplicationUser)iterator.next();
            return this.permissionManager.hasPermission(this.permission, user);
        }
        return false;
    }

    public int getRoleCount() {
        return this.globalPermissionUserCountCache.getUserCount(this.permission);
    }
}

